/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@ConditionalOnMissingBean(value={TaskExecutor.class})
public class TaskExecutorConfiguration {
    @Autowired
    private Environment env;

    @Bean
    public TaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(((Integer)this.env.getProperty("batch.core.pool.size", Integer.class, (Object)5)).intValue());
        taskExecutor.setQueueCapacity(((Integer)this.env.getProperty("batch.queue.capacity", Integer.class, (Object)Integer.MAX_VALUE)).intValue());
        taskExecutor.setMaxPoolSize(((Integer)this.env.getProperty("batch.max.pool.size", Integer.class, (Object)Integer.MAX_VALUE)).intValue());
        taskExecutor.afterPropertiesSet();
        return taskExecutor;
    }
}

