/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.configuration.BaseConfiguration;
import de.codecentric.batch.configuration.ListenerProvider;
import de.codecentric.batch.metrics.BatchMetricsImpl;
import de.codecentric.batch.metrics.MetricsListener;
import de.codecentric.batch.metrics.ReaderProcessorWriterMetricsAspect;
import java.util.HashSet;
import java.util.Set;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.rich.InMemoryRichGaugeRepository;
import org.springframework.boot.actuate.metrics.rich.RichGaugeRepository;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@ConditionalOnProperty(value={"batch.metrics.enabled"})
@Configuration
public class MetricsConfiguration
implements ListenerProvider {
    @Autowired
    private Environment env;
    @Autowired
    private BaseConfiguration baseConfig;
    @Autowired
    private RichGaugeRepository richGaugeRepository;
    @Autowired
    private MetricWriter metricWriter;

    @Bean
    public BatchMetricsImpl batchMetrics() {
        return new BatchMetricsImpl(this.metricWriter);
    }

    @ConditionalOnProperty(value={"batch.metrics.profiling.readprocesswrite.enabled"})
    @Bean
    public ReaderProcessorWriterMetricsAspect batchMetricsAspects() {
        return new ReaderProcessorWriterMetricsAspect(this.baseConfig.gaugeService());
    }

    @Bean
    public MetricsListener metricsListener() {
        return new MetricsListener(this.richGaugeRepository, this.baseConfig.metricRepository(), (Boolean)this.env.getProperty("batch.metrics.deletemetricsonstepfinish", Boolean.TYPE, (Object)true));
    }

    @Override
    public Set<JobExecutionListener> jobExecutionListeners() {
        return new HashSet<JobExecutionListener>();
    }

    @Override
    public Set<StepExecutionListener> stepExecutionListeners() {
        HashSet<StepExecutionListener> listeners = new HashSet<StepExecutionListener>();
        listeners.add((StepExecutionListener)this.metricsListener());
        return listeners;
    }

    @ConditionalOnProperty(value={"batch.metrics.enabled"})
    @Configuration
    static class MetricsRepositoryConfiguration {
        MetricsRepositoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={RichGaugeRepository.class})
        public RichGaugeRepository richGaugeRepository() {
            return new InMemoryRichGaugeRepository();
        }
    }
}

