/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.configuration.BaseConfiguration;
import de.codecentric.batch.configuration.BatchWebAutoConfiguration;
import de.codecentric.batch.configuration.StepExecutionJacksonMixIn;
import de.codecentric.batch.web.JobMonitoringController;
import de.codecentric.batch.web.JobOperationsController;
import java.util.List;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.jsr.launch.JsrJobOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class WebConfig
extends WebMvcConfigurerAdapter {
    @Autowired
    private BaseConfiguration baseConfig;
    @Autowired
    private BatchWebAutoConfiguration batchWebAutoConfiguration;
    @Autowired(required=false)
    private JsrJobOperator jsrJobOperator;

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> httpMessageConverter : converters) {
            if (!(httpMessageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter converter = (MappingJackson2HttpMessageConverter)httpMessageConverter;
            converter.getObjectMapper().addMixInAnnotations(StepExecution.class, StepExecutionJacksonMixIn.class);
        }
    }

    @Bean
    public JobMonitoringController jobMonitoringController() {
        return new JobMonitoringController(this.baseConfig.jobOperator(), this.baseConfig.jobExplorer(), this.batchWebAutoConfiguration.runningExecutionTracker());
    }

    @Bean
    public JobOperationsController jobOperationsController() {
        return new JobOperationsController(this.baseConfig.jobOperator(), this.baseConfig.jobExplorer(), this.baseConfig.jobRegistry(), this.baseConfig.jobRepository(), this.baseConfig.jobLauncher(), this.jsrJobOperator);
    }
}

