/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.listener;

import de.codecentric.batch.listener.LoggingAfterJobListener;
import de.codecentric.batch.listener.LoggingListener;
import de.codecentric.batch.listener.ProtocolListener;
import de.codecentric.batch.listener.RunningExecutionTrackerListener;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.step.AbstractStep;

public class AddListenerToJobService {
    private boolean addProtocolListener;
    private boolean addLoggingListener;
    private ProtocolListener protocolListener;
    private RunningExecutionTrackerListener runningExecutionTrackerListener;
    private LoggingListener loggingListener;
    private LoggingAfterJobListener loggingAfterJobListener;

    public AddListenerToJobService(boolean addProtocolListener, boolean addLoggingListener, ProtocolListener protocolListener, RunningExecutionTrackerListener runningExecutionTrackerListener, LoggingListener loggingListener, LoggingAfterJobListener loggingAfterJobListener) {
        this.addProtocolListener = addProtocolListener;
        this.addLoggingListener = addLoggingListener;
        this.protocolListener = protocolListener;
        this.runningExecutionTrackerListener = runningExecutionTrackerListener;
        this.loggingListener = loggingListener;
        this.loggingAfterJobListener = loggingAfterJobListener;
    }

    public void addListenerToJob(AbstractJob job) {
        if (this.addProtocolListener) {
            job.registerJobExecutionListener((JobExecutionListener)this.protocolListener);
        }
        job.registerJobExecutionListener((JobExecutionListener)this.runningExecutionTrackerListener);
        if (this.addLoggingListener) {
            job.registerJobExecutionListener((JobExecutionListener)this.loggingListener);
            job.registerJobExecutionListener((JobExecutionListener)this.loggingAfterJobListener);
            for (String stepName : job.getStepNames()) {
                AbstractStep step = (AbstractStep)job.getStep(stepName);
                step.registerStepExecutionListener((StepExecutionListener)this.loggingListener);
            }
        }
    }
}

