/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.configuration.AutomaticJobRegistrarConfiguration;
import de.codecentric.batch.configuration.BaseConfiguration;
import de.codecentric.batch.configuration.Jsr352BatchConfiguration;
import de.codecentric.batch.configuration.TaskExecutorBatchConfigurer;
import de.codecentric.batch.configuration.WebConfig;
import de.codecentric.batch.listener.AddListenerToJobService;
import de.codecentric.batch.listener.LoggingAfterJobListener;
import de.codecentric.batch.listener.LoggingListener;
import de.codecentric.batch.listener.ProtocolListener;
import de.codecentric.batch.listener.RunningExecutionTrackerListener;
import de.codecentric.batch.monitoring.RunningExecutionTracker;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

@Configuration
@EnableBatchProcessing(modular=true)
@PropertySource(value={"classpath:spring-boot-starter-batch-web.properties"})
@Import(value={WebConfig.class, TaskExecutorBatchConfigurer.class, AutomaticJobRegistrarConfiguration.class, BaseConfiguration.class, Jsr352BatchConfiguration.class})
public class BatchWebAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    @Autowired
    private Environment env;
    @Autowired
    private BaseConfiguration baseConfig;

    @Bean
    public LoggingListener loggingListener() {
        return new LoggingListener();
    }

    @Bean
    public LoggingAfterJobListener loggingAfterJobListener() {
        return new LoggingAfterJobListener();
    }

    @Bean
    public ProtocolListener protocolListener() {
        return new ProtocolListener();
    }

    @Bean
    public RunningExecutionTracker runningExecutionTracker() {
        return new RunningExecutionTracker();
    }

    @Bean
    public RunningExecutionTrackerListener runningExecutionTrackerListener() {
        return new RunningExecutionTrackerListener(this.runningExecutionTracker());
    }

    @Bean
    public AddListenerToJobService addListenerToJobService() {
        boolean addProtocolListener = (Boolean)this.env.getProperty("batch.defaultprotocol.enabled", Boolean.TYPE, (Object)true);
        boolean addLoggingListener = (Boolean)this.env.getProperty("batch.logfileseparation.enabled", Boolean.TYPE, (Object)true);
        return new AddListenerToJobService(addProtocolListener, addLoggingListener, this.protocolListener(), this.runningExecutionTrackerListener(), this.loggingListener(), this.loggingAfterJobListener());
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            for (String jobName : this.baseConfig.jobRegistry().getJobNames()) {
                AbstractJob job = (AbstractJob)this.baseConfig.jobRegistry().getJob(jobName);
                this.addListenerToJobService().addListenerToJob(job);
            }
        }
        catch (NoSuchJobException e) {
            throw new IllegalStateException(e);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

