/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.web;

import de.codecentric.batch.monitoring.RunningExecutionTracker;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${batch.web.monitoring.base:/batch/monitoring}"})
public class JobMonitoringController {
    private static final Logger LOG = LoggerFactory.getLogger(JobMonitoringController.class);
    private JobOperator jobOperator;
    private JobExplorer jobExplorer;
    private RunningExecutionTracker runningExecutionTracker;

    public JobMonitoringController(JobOperator jobOperator, JobExplorer jobExplorer, RunningExecutionTracker runningExecutionTracker) {
        this.jobOperator = jobOperator;
        this.jobExplorer = jobExplorer;
        this.runningExecutionTracker = runningExecutionTracker;
    }

    @RequestMapping(value={"/jobs"}, method={RequestMethod.GET})
    public Set<String> findRegisteredJobs() {
        return this.jobOperator.getJobNames();
    }

    @RequestMapping(value={"/jobs/runningexecutions"}, method={RequestMethod.GET})
    public Set<Long> findAllRunningExecutions() {
        return this.runningExecutionTracker.getAllRunningExecutionIds();
    }

    @RequestMapping(value={"/jobs/runningexecutions/{jobName}"}, method={RequestMethod.GET})
    public Set<Long> findRunningExecutionsForJobName(@PathVariable String jobName) {
        return this.runningExecutionTracker.getRunningExecutionIdsForJobName(jobName);
    }

    @RequestMapping(value={"/jobs/executions/{executionId}"}, method={RequestMethod.GET})
    public JobExecution findExecution(@PathVariable long executionId) throws NoSuchJobExecutionException {
        JobExecution jobExecution = this.jobExplorer.getJobExecution(Long.valueOf(executionId));
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("JobExecution with id " + executionId + " not found.");
        }
        return jobExecution;
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NoSuchJobExecutionException.class})
    public String handleNotFound(Exception ex) {
        LOG.warn("JobExecution not found.", (Throwable)ex);
        return ex.getMessage();
    }
}

