/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.web;

import de.codecentric.batch.logging.DefaultJobLogFileNameCreator;
import de.codecentric.batch.logging.JobLogFileNameCreator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobInstanceAlreadyExistsException;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.support.PropertiesConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${batch.web.operations.base:/batch/operations}"})
public class JobOperationsController {
    private static final Logger LOG = LoggerFactory.getLogger(JobOperationsController.class);
    public static final String JOB_PARAMETERS = "jobParameters";
    private JobOperator jobOperator;
    private JobExplorer jobExplorer;
    private JobRegistry jobRegistry;
    private JobRepository jobRepository;
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();
    private JobLogFileNameCreator jobLogFileNameCreator = new DefaultJobLogFileNameCreator();

    public JobOperationsController(JobOperator jobOperator, JobExplorer jobExplorer, JobRegistry jobRegistry, JobRepository jobRepository) {
        this.jobOperator = jobOperator;
        this.jobExplorer = jobExplorer;
        this.jobRegistry = jobRegistry;
        this.jobRepository = jobRepository;
    }

    @RequestMapping(value={"/jobs/{jobName}"}, method={RequestMethod.POST})
    public String launch(@PathVariable String jobName, @RequestParam MultiValueMap<String, String> payload) throws NoSuchJobException, JobInstanceAlreadyExistsException, JobParametersInvalidException {
        String parameters = (String)payload.getFirst((Object)JOB_PARAMETERS);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempt to start job with name " + jobName + " and parameters " + parameters + ".");
        }
        Job job = this.jobRegistry.getJob(jobName);
        parameters = this.createJobParametersWithIncrementerIfAvailable(parameters, job);
        Long id = this.jobOperator.start(jobName, parameters);
        return String.valueOf(id);
    }

    private String createJobParametersWithIncrementerIfAvailable(String parameters, Job job) {
        JobParameters jobParameters = this.jobParametersConverter.getJobParameters(PropertiesConverter.stringToProperties((String)parameters));
        if (job.getJobParametersIncrementer() != null) {
            BatchStatus status;
            JobExecution lastJobExecution = this.jobRepository.getLastJobExecution(job.getName(), jobParameters);
            boolean restart = false;
            if (lastJobExecution != null && (status = lastJobExecution.getStatus()).isUnsuccessful() && status != BatchStatus.ABANDONED) {
                restart = true;
            }
            if (!restart) {
                jobParameters = job.getJobParametersIncrementer().getNext(jobParameters);
                Properties newParameters = this.jobParametersConverter.getProperties(jobParameters);
                parameters = PropertiesConverter.propertiesToString((Properties)newParameters);
            }
        }
        return parameters;
    }

    @RequestMapping(value={"/jobs/executions/{executionId}"}, method={RequestMethod.GET})
    public String getStatus(@PathVariable long executionId) throws NoSuchJobExecutionException {
        JobExecution jobExecution;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get BatchStatus for JobExecution with id: " + executionId + ".");
        }
        if ((jobExecution = this.jobExplorer.getJobExecution(Long.valueOf(executionId))) != null) {
            return jobExecution.getStatus().toString();
        }
        throw new NoSuchJobExecutionException("JobExecution with id " + executionId + " not found.");
    }

    @RequestMapping(value={"/jobs/executions/{executionId}/log"}, method={RequestMethod.GET})
    public void getLogFile(HttpServletResponse response, @PathVariable long executionId) throws NoSuchJobExecutionException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get log file for job with executionId: " + executionId);
        }
        String loggingPath = this.createLoggingPath();
        JobExecution jobExecution = this.jobExplorer.getJobExecution(Long.valueOf(executionId));
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("JobExecution with id " + executionId + " not found.");
        }
        File downloadFile = new File(loggingPath + this.jobLogFileNameCreator.createJobLogFileName(jobExecution));
        FileInputStream is = new FileInputStream(downloadFile);
        FileCopyUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
        response.flushBuffer();
    }

    private String createLoggingPath() {
        String loggingPath = System.getProperty("LOG_PATH");
        if (loggingPath == null) {
            loggingPath = System.getProperty("java.io.tmpdir");
        }
        if (loggingPath == null) {
            loggingPath = "/tmp";
        }
        if (!loggingPath.endsWith("/")) {
            loggingPath = loggingPath + "/";
        }
        return loggingPath;
    }

    @RequestMapping(value={"/jobs/executions/{executionId}"}, method={RequestMethod.DELETE})
    public String stop(@PathVariable long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stop JobExecution with id: " + executionId);
        }
        Boolean successful = this.jobOperator.stop(executionId);
        return successful.toString();
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NoSuchJobException.class, NoSuchJobExecutionException.class})
    public String handleNotFound(Exception ex) {
        LOG.warn("Job or JobExecution not found.", (Throwable)ex);
        return ex.getMessage();
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={UnexpectedJobExecutionException.class, JobInstanceAlreadyExistsException.class})
    public String handleAlreadyExists(Exception ex) {
        LOG.warn("JobInstance or JobExecution already exists.", (Throwable)ex);
        return ex.getMessage();
    }

    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ExceptionHandler(value={JobParametersInvalidException.class})
    public String handleParametersInvalid(Exception ex) {
        LOG.warn("Job parameters are invalid.", (Throwable)ex);
        return ex.getMessage();
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={FileNotFoundException.class})
    public String handleFileNotFound(Exception ex) {
        LOG.warn("Logfile not found.", (Throwable)ex);
        return ex.getMessage();
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={JobExecutionNotRunningException.class})
    public String handleNotRunning(Exception ex) {
        LOG.warn("JobExecution is not running.", (Throwable)ex);
        return ex.getMessage();
    }

    @Autowired(required=false)
    public void setJobLogFileNameCreator(JobLogFileNameCreator jobLogFileNameCreator) {
        this.jobLogFileNameCreator = jobLogFileNameCreator;
    }
}

