/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.configuration.AutomaticJobRegistrarConfiguration;
import de.codecentric.batch.configuration.TaskExecutorBatchConfigurer;
import de.codecentric.batch.configuration.WebConfig;
import de.codecentric.batch.listener.LoggingAfterJobListener;
import de.codecentric.batch.listener.LoggingListener;
import de.codecentric.batch.listener.ProtocolListener;
import de.codecentric.batch.listener.RunningExecutionTrackerListener;
import de.codecentric.batch.monitoring.RunningExecutionTracker;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

@Configuration
@EnableBatchProcessing(modular=true)
@PropertySource(value={"classpath:spring-boot-starter-batch-web.properties"})
@Import(value={WebConfig.class, TaskExecutorBatchConfigurer.class, AutomaticJobRegistrarConfiguration.class})
public class BatchWebAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    @Autowired
    private Environment env;
    @Autowired
    private JobRegistry jobRegistry;

    @Bean
    public LoggingListener loggingListener() {
        return new LoggingListener();
    }

    @Bean
    public LoggingAfterJobListener loggingReDoListener() {
        return new LoggingAfterJobListener();
    }

    @Bean
    public ProtocolListener protocolListener() {
        return new ProtocolListener();
    }

    @Bean
    public RunningExecutionTracker runningExecutionTracker() {
        return new RunningExecutionTracker();
    }

    @Bean
    public RunningExecutionTrackerListener runningExecutionTrackerListener() {
        return new RunningExecutionTrackerListener(this.runningExecutionTracker());
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            this.addListenerToJob();
        }
        catch (NoSuchJobException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addListenerToJob() throws NoSuchJobException {
        boolean addProtocolListener = (Boolean)this.env.getProperty("batch.defaultprotocol.enabled", Boolean.TYPE, (Object)true);
        boolean addLoggingListener = (Boolean)this.env.getProperty("batch.logfileseparation.enabled", Boolean.TYPE, (Object)true);
        for (String jobName : this.jobRegistry.getJobNames()) {
            AbstractJob job = (AbstractJob)this.jobRegistry.getJob(jobName);
            if (addProtocolListener) {
                job.registerJobExecutionListener((JobExecutionListener)this.protocolListener());
            }
            job.registerJobExecutionListener((JobExecutionListener)this.runningExecutionTrackerListener());
            if (!addLoggingListener) continue;
            job.registerJobExecutionListener((JobExecutionListener)this.loggingListener());
            job.registerJobExecutionListener((JobExecutionListener)this.loggingReDoListener());
            for (String stepName : job.getStepNames()) {
                AbstractStep step = (AbstractStep)job.getStep(stepName);
                step.registerStepExecutionListener((StepExecutionListener)this.loggingListener());
            }
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

