/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.web.filter.OncePerRequestFilter;

public class EndpointCorsFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointCorsFilter.class);
    @Value(value="${http.filter.cors.origin:*}")
    private String origin;
    @Value(value="${http.filter.cors.headers:Origin, X-Requested-With, Content-Type, Accept}")
    private String headers;
    private final EndpointHandlerMapping endpointHandlerMapping;

    public EndpointCorsFilter(EndpointHandlerMapping endpointHandlerMapping) {
        this.endpointHandlerMapping = endpointHandlerMapping;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            if (!this.endpointHandlerMapping.isDisabled() && this.endpointHandlerMapping.getHandler(request) != null) {
                response.setHeader("Access-Control-Allow-Origin", this.origin);
                response.setHeader("Access-Control-Allow-Headers", this.headers);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Error occured while adding CORS-Headers", (Throwable)ex);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }
}

