/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Application
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String url;
    private final String name;

    public Application(String url, String name) {
        this(url, name, null);
    }

    @JsonCreator
    public Application(@JsonProperty(value="url", required=true) String url, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="id") String id) {
        this.url = url.replaceFirst("/+$", "");
        this.name = name;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "[id=" + this.id + ", url=" + this.url + ", name=" + this.name + "]";
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Application other = (Application)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

