/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LogfileController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogfileController.class);
    @Autowired
    private Environment env;

    @RequestMapping(value={"/logfile"})
    @ResponseBody
    public String getLogfile(HttpServletResponse response) {
        String path = this.env.getProperty("logging.file");
        if (path == null) {
            LOGGER.error("Logfile download failed for missing property 'logging.file'");
            return "Logfile download failed for missing property 'logging.file'";
        }
        FileSystemResource file = new FileSystemResource(path);
        if (!file.exists()) {
            LOGGER.error("Logfile download failed for missing file at path=" + path);
            return "Logfile download failed for missing file at path=" + path;
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getFilename() + "\"");
        try {
            FileCopyUtils.copy((InputStream)file.getInputStream(), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            LOGGER.error("Logfile download failed for path=" + path);
            return "Logfile download failed for path=" + path;
        }
        return null;
    }
}

