/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.services;

import de.codecentric.boot.admin.model.Application;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class SpringBootAdminRegistratorTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootAdminRegistratorTask.class);
    @Autowired
    private Environment env;

    @PostConstruct
    public void check() {
        Assert.notNull((Object)this.env.getProperty("spring.boot.admin.url"), (String)"The URL of the spring-boot-admin application is mandatory");
        Assert.notNull((Object)this.env.getProperty("server.port"), (String)"The server port of the application is mandatory");
        Assert.notNull((Object)this.env.getProperty("info.id"), (String)"The id of the application is mandatory");
    }

    @Override
    public void run() {
        try {
            Application app2;
            String id = this.env.getProperty("info.id");
            int port = (Integer)this.env.getProperty("server.port", Integer.class);
            String adminUrl = this.env.getProperty("spring.boot.admin.url");
            RestTemplate template = new RestTemplate();
            template.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
            ApplicationList list = (ApplicationList)template.getForObject(adminUrl + "/api/applications", ApplicationList.class, new Object[0]);
            for (Application app2 : list) {
                if (!id.equals(app2.getId())) continue;
                LOGGER.debug("Application already registered with ID '{}'", (Object)id);
                return;
            }
            String url = new URL("http", InetAddress.getLocalHost().getCanonicalHostName(), port, "").toString();
            app2 = new Application();
            app2.setId(id);
            app2.setUrl(url);
            template.postForObject(adminUrl + "/api/applications", (Object)app2, String.class, new Object[0]);
            LOGGER.info("Application registered itself at the admin application with ID '{}' and URL '{}'", (Object)id, (Object)url);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register application at spring-boot-admin, message={}", (Object)e.getMessage());
        }
    }

    private static class ApplicationList
    extends ArrayList<Application> {
        private static final long serialVersionUID = 1L;

        private ApplicationList() {
        }
    }
}

