/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.config;

import de.codecentric.boot.admin.client.config.AdminClientProperties;
import de.codecentric.boot.admin.client.config.AdminProperties;
import de.codecentric.boot.admin.client.config.SpringBootAdminClientEnabledCondition;
import de.codecentric.boot.admin.client.registration.ApplicationFactory;
import de.codecentric.boot.admin.client.registration.ApplicationRegistrator;
import de.codecentric.boot.admin.client.registration.DefaultApplicationFactory;
import de.codecentric.boot.admin.client.registration.RegistrationApplicationListener;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableConfigurationProperties(value={AdminProperties.class, AdminClientProperties.class})
@Conditional(value={SpringBootAdminClientEnabledCondition.class})
public class SpringBootAdminClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ApplicationRegistrator registrator(AdminProperties admin, ApplicationFactory applicationFactory, RestTemplateBuilder restTemplBuilder) {
        RestTemplateBuilder builder = restTemplBuilder.messageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()}).requestFactory(SimpleClientHttpRequestFactory.class);
        if (admin.getUsername() != null) {
            builder = builder.basicAuthorization(admin.getUsername(), admin.getPassword());
        }
        return new ApplicationRegistrator(builder.build(), admin, applicationFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationFactory applicationFactory(AdminClientProperties client, ManagementServerProperties management, ServerProperties server, @Value(value="${endpoints.health.path:/${endpoints.health.id:health}}") String healthEndpointPath, ServletContext servletContext) {
        return new DefaultApplicationFactory(client, management, server, servletContext, healthEndpointPath);
    }

    @Bean
    @Qualifier(value="registrationTaskScheduler")
    public TaskScheduler registrationTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(1);
        taskScheduler.setRemoveOnCancelPolicy(true);
        taskScheduler.setThreadNamePrefix("registrationTask");
        return taskScheduler;
    }

    @Bean
    @ConditionalOnMissingBean
    public RegistrationApplicationListener registrationListener(AdminProperties admin, ApplicationRegistrator registrator) {
        RegistrationApplicationListener listener = new RegistrationApplicationListener(registrator, this.registrationTaskScheduler());
        listener.setAutoRegister(admin.isAutoRegistration());
        listener.setAutoDeregister(admin.isAutoDeregistration());
        listener.setRegisterPeriod(admin.getPeriod());
        return listener;
    }
}

