/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.services;

import de.codecentric.boot.admin.config.AdminProperties;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.services.ApplicationFactory;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ApplicationRegistrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRegistrator.class);
    private static final HttpHeaders HTTP_HEADERS = ApplicationRegistrator.createHttpHeaders();
    private final AtomicReference<String> registeredId = new AtomicReference();
    private final AdminProperties admin;
    private final RestTemplate template;
    private final ApplicationFactory applicationFactory;

    public ApplicationRegistrator(RestTemplate template, AdminProperties admin, ApplicationFactory applicationFactory) {
        this.admin = admin;
        this.template = template;
        this.applicationFactory = applicationFactory;
    }

    private static HttpHeaders createHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
    }

    public boolean register() {
        boolean isRegistrationSuccessful = false;
        Application self = this.createApplication();
        for (String adminUrl : this.admin.getAdminUrl()) {
            try {
                ResponseEntity response = this.template.postForEntity(adminUrl, (Object)new HttpEntity((Object)self, (MultiValueMap)HTTP_HEADERS), Map.class, new Object[0]);
                if (response.getStatusCode().equals((Object)HttpStatus.CREATED)) {
                    if (this.registeredId.compareAndSet(null, ((Map)response.getBody()).get("id").toString())) {
                        LOGGER.info("Application registered itself as {}", response.getBody());
                    } else {
                        LOGGER.debug("Application refreshed itself as {}", response.getBody());
                    }
                    isRegistrationSuccessful = true;
                    if (!this.admin.isRegisterOnce()) continue;
                    break;
                }
                LOGGER.warn("Application failed to registered itself as {}. Response: {}", (Object)self, (Object)response.toString());
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to register application as {} at spring-boot-admin ({}): {}", new Object[]{self, this.admin.getAdminUrl(), ex.getMessage()});
            }
        }
        return isRegistrationSuccessful;
    }

    public void deregister() {
        String id = this.registeredId.get();
        if (id != null) {
            for (String adminUrl : this.admin.getAdminUrl()) {
                try {
                    this.template.delete(adminUrl + "/" + id, new Object[0]);
                    this.registeredId.compareAndSet(id, null);
                    if (!this.admin.isRegisterOnce()) continue;
                    break;
                }
                catch (Exception ex) {
                    LOGGER.warn("Failed to deregister application (id={}) at spring-boot-admin ({}): {}", new Object[]{id, adminUrl, ex.getMessage()});
                }
            }
        }
    }

    protected Application createApplication() {
        return this.applicationFactory.createApplication();
    }
}

