/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.config.AdminClientProperties;
import de.codecentric.boot.admin.config.AdminProperties;
import de.codecentric.boot.admin.config.SpringBootAdminClientEnabledCondition;
import de.codecentric.boot.admin.services.ApplicationRegistrator;
import de.codecentric.boot.admin.services.RegistrationApplicationListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
@EnableConfigurationProperties(value={AdminProperties.class, AdminClientProperties.class})
@Conditional(value={SpringBootAdminClientEnabledCondition.class})
public class SpringBootAdminClientAutoConfiguration {
    @Autowired
    private AdminClientProperties client;
    @Autowired
    private AdminProperties admin;
    @Autowired
    private RestTemplateBuilder builder;

    @Bean
    @ConditionalOnMissingBean
    public ApplicationRegistrator registrator() {
        this.builder.messageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()});
        if (this.admin.getUsername() != null) {
            this.builder.basicAuthorization(this.admin.getUsername(), this.admin.getPassword());
        }
        return new ApplicationRegistrator(this.builder.build(), this.admin, this.client);
    }

    @Bean
    @ConditionalOnMissingBean
    public RegistrationApplicationListener registrationListener() {
        RegistrationApplicationListener listener = new RegistrationApplicationListener(this.registrator());
        listener.setAutoRegister(this.admin.isAutoRegistration());
        listener.setAutoDeregister(this.admin.isAutoDeregistration());
        listener.setRegisterPeriod(this.admin.getPeriod());
        return listener;
    }
}

