/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.services;

import de.codecentric.boot.admin.config.AdminClientProperties;
import de.codecentric.boot.admin.config.AdminProperties;
import de.codecentric.boot.admin.model.Application;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ApplicationRegistrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRegistrator.class);
    private static HttpHeaders HTTP_HEADERS = ApplicationRegistrator.createHttpHeaders();
    private final AtomicReference<Application> registeredSelf = new AtomicReference();
    private AdminClientProperties client;
    private AdminProperties admin;
    private final RestTemplate template;

    public ApplicationRegistrator(RestTemplate template, AdminProperties admin, AdminClientProperties client) {
        this.client = client;
        this.admin = admin;
        this.template = template;
    }

    private static HttpHeaders createHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
    }

    public boolean register() {
        Application self = null;
        String adminUrl = this.admin.getUrl() + '/' + this.admin.getContextPath();
        try {
            self = this.createApplication();
            ResponseEntity response = this.template.postForEntity(adminUrl, (Object)new HttpEntity((Object)self, (MultiValueMap)HTTP_HEADERS), Application.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.CREATED)) {
                if (this.registeredSelf.get() == null && this.registeredSelf.compareAndSet(null, (Application)response.getBody())) {
                    LOGGER.info("Application registered itself as {}", response.getBody());
                    return true;
                }
                LOGGER.debug("Application refreshed itself as {}", response.getBody());
                return true;
            }
            LOGGER.warn("Application failed to registered itself as {}. Response: {}", (Object)self, (Object)response.toString());
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to register application as {} at spring-boot-admin ({}): {}", new Object[]{self, adminUrl, ex.getMessage()});
        }
        return false;
    }

    public void deregister() {
        Application self = this.registeredSelf.get();
        if (self != null) {
            String adminUrl = this.admin.getUrl() + '/' + this.admin.getContextPath() + "/" + self.getId();
            this.registeredSelf.set(null);
            try {
                this.template.delete(adminUrl, new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to deregister application as {} at spring-boot-admin ({}): {}", new Object[]{self, adminUrl, ex.getMessage()});
            }
        }
    }

    protected Application createApplication() {
        return Application.create(this.client.getName()).withHealthUrl(this.client.getHealthUrl()).withManagementUrl(this.client.getManagementUrl()).withServiceUrl(this.client.getServiceUrl()).build();
    }
}

