/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.actuate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@ConfigurationProperties(prefix="endpoints.logfile")
public class LogfileMvcEndpoint
implements MvcEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogfileMvcEndpoint.class);
    @Value(value="${logging.file}")
    private String logfile;
    private String path = "/logfile";
    private boolean sensitive = true;
    private boolean enabled = true;

    public boolean isSensitive() {
        return this.sensitive;
    }

    public String getPath() {
        return this.path;
    }

    public Class<? extends Endpoint> getEndpointType() {
        return null;
    }

    public void setLogfile(String logfile) {
        this.logfile = logfile;
    }

    public String getLogfile() {
        return this.logfile;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @RequestMapping(method={RequestMethod.GET})
    public void invoke(HttpServletResponse response) throws IOException {
        if (!this.isAvailable()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        FileSystemResource file = new FileSystemResource(this.logfile);
        response.setContentType("text/plain");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getFilename() + "\"");
        FileCopyUtils.copy((InputStream)file.getInputStream(), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(method={RequestMethod.HEAD})
    @ResponseBody
    public ResponseEntity<Object> available() {
        if (this.isAvailable()) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    private boolean isAvailable() {
        if (!this.enabled) {
            return false;
        }
        if (this.logfile == null) {
            LOGGER.error("Logfile download failed for missing property 'logging.file'");
            return false;
        }
        FileSystemResource file = new FileSystemResource(this.logfile);
        if (!file.exists()) {
            LOGGER.error("Logfile download failed for missing file at path={}", (Object)this.logfile);
            return false;
        }
        return true;
    }
}

