/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.HttpHeaders;

public class HttpHeaderFilter {
    private static final String[] HOP_BY_HOP_HEADERS = new String[]{"Host", "Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "X-Application-Context"};
    private final Set<String> ignoredHeaders;

    public HttpHeaderFilter(Set<String> ignoredHeaders) {
        this.ignoredHeaders = Stream.concat(ignoredHeaders.stream(), Arrays.stream(HOP_BY_HOP_HEADERS)).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public HttpHeaders filterHeaders(HttpHeaders headers) {
        HttpHeaders filtered = new HttpHeaders();
        filtered.putAll(headers.entrySet().stream().filter(e -> this.includeHeader((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return filtered;
    }

    private boolean includeHeader(String header) {
        return !this.ignoredHeaders.contains(header.toLowerCase());
    }
}

