/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.domain.values;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.util.StringUtils;

public final class Tags
implements Serializable {
    private final Map<String, String> values;
    private static final Tags EMPTY = new Tags(Collections.emptyMap());

    private Tags(Map<String, String> tags) {
        this.values = tags.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, String>(tags));
    }

    @JsonAnyGetter
    public Map<String, String> getValues() {
        return this.values;
    }

    public Tags append(Tags other) {
        LinkedHashMap<String, String> newTags = new LinkedHashMap<String, String>(this.values);
        newTags.putAll(other.values);
        return new Tags(newTags);
    }

    public static Tags empty() {
        return EMPTY;
    }

    public static Tags from(Map<String, ?> map) {
        return Tags.from(map, null);
    }

    public static Tags from(Map<String, ?> map, @Nullable String prefix) {
        if (map.isEmpty()) {
            return Tags.empty();
        }
        if (StringUtils.hasText((String)prefix)) {
            Object nestedTags = map.get(prefix);
            if (nestedTags instanceof Map) {
                return Tags.from((Map)nestedTags);
            }
            String flatPrefix = prefix + ".";
            return Tags.from((Map)map.entrySet().stream().filter(e -> ((String)e.getKey()).toLowerCase().startsWith(flatPrefix)).collect(Tags.toLinkedHashMap(e -> ((String)e.getKey()).substring(flatPrefix.length()), Map.Entry::getValue)));
        }
        return new Tags((Map<String, String>)map.entrySet().stream().collect(Tags.toLinkedHashMap(Map.Entry::getKey, e -> Objects.toString(e.getValue()))));
    }

    private static <T, K, U> Collector<T, ?, LinkedHashMap<K, U>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tags)) {
            return false;
        }
        Tags other = (Tags)o;
        Map<String, String> this$values = this.getValues();
        Map<String, String> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "Tags(values=" + this.getValues() + ")";
    }
}

