/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.servlet;

import de.codecentric.boot.admin.server.web.AdminController;
import de.codecentric.boot.admin.server.web.PathUtils;
import java.lang.reflect.Method;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class AdminControllerHandlerMapping
extends RequestMappingHandlerMapping {
    private final String adminContextPath;

    public AdminControllerHandlerMapping(String adminContextPath) {
        this.adminContextPath = adminContextPath;
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotatedElementUtils.hasAnnotation(beanType, AdminController.class);
    }

    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        super.registerHandlerMethod(handler, method, (Object)this.withPrefix(mapping));
    }

    private RequestMappingInfo withPrefix(RequestMappingInfo mapping) {
        if (!StringUtils.hasText((String)this.adminContextPath)) {
            return mapping;
        }
        PatternsRequestCondition patternsCondition = new PatternsRequestCondition(this.withNewPatterns(mapping.getPatternsCondition().getPatterns()));
        return new RequestMappingInfo(patternsCondition, mapping.getMethodsCondition(), mapping.getParamsCondition(), mapping.getHeadersCondition(), mapping.getConsumesCondition(), mapping.getProducesCondition(), mapping.getCustomCondition());
    }

    private String[] withNewPatterns(Set<String> patterns) {
        return (String[])patterns.stream().map(pattern -> PathUtils.normalizePath(this.adminContextPath + pattern)).toArray(String[]::new);
    }
}

