/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.services.EndpointDetector;
import de.codecentric.boot.admin.server.services.ResubscribingEventHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class EndpointDetectionTrigger
extends ResubscribingEventHandler<InstanceStatusChangedEvent> {
    private final EndpointDetector endpointDetector;

    public EndpointDetectionTrigger(EndpointDetector endpointDetector, Publisher<InstanceEvent> publisher) {
        super(publisher, InstanceStatusChangedEvent.class);
        this.endpointDetector = endpointDetector;
    }

    @Override
    protected Publisher<?> handle(Flux<InstanceStatusChangedEvent> publisher) {
        return publisher.subscribeOn(Schedulers.newSingle((String)"endpoint-detector")).flatMap(this::detectEndpoints);
    }

    protected Mono<Void> detectEndpoints(InstanceStatusChangedEvent event) {
        return this.endpointDetector.detectEndpoints(event.getInstance());
    }
}

