/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import java.util.Arrays;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;

public class MailNotifier
implements ApplicationListener<ClientApplicationStatusChangedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailNotifier.class);
    private final String DEFAULT_SUBJECT = "#{application.name} (#{application.id}) is #{to.status}";
    private final String DEFAULT_TEXT = "#{application.name} (#{application.id})\nstatus changed from #{from.status} to #{to.status}\n\n#{application.healthUrl}";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private MailSender sender;
    private String[] to = new String[]{"root@localhost"};
    private String[] cc;
    private String from = null;
    private Expression text;
    private Expression subject;
    private String[] ignoreChanges = new String[]{"UNKNOWN:UP"};
    private boolean enabled = true;

    public MailNotifier(MailSender sender) {
        this.sender = sender;
        this.subject = this.parser.parseExpression("#{application.name} (#{application.id}) is #{to.status}", ParserContext.TEMPLATE_EXPRESSION);
        this.text = this.parser.parseExpression("#{application.name} (#{application.id})\nstatus changed from #{from.status} to #{to.status}\n\n#{application.healthUrl}", ParserContext.TEMPLATE_EXPRESSION);
    }

    public void onApplicationEvent(ClientApplicationStatusChangedEvent event) {
        if (this.enabled && this.shouldSendMail(event.getFrom().getStatus(), event.getTo().getStatus())) {
            try {
                this.sendMail(event);
            }
            catch (Exception ex) {
                LOGGER.error("Couldn't send mail for Statuschange {} ", (Object)event, (Object)ex);
            }
        }
    }

    private void sendMail(ClientApplicationStatusChangedEvent event) throws MessagingException {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)event);
        SimpleMailMessage message = new SimpleMailMessage();
        message.setTo(this.to);
        message.setFrom(this.from);
        message.setSubject((String)this.subject.getValue((EvaluationContext)context, String.class));
        message.setText((String)this.text.getValue((EvaluationContext)context, String.class));
        message.setCc(this.cc);
        this.sender.send(message);
    }

    private boolean shouldSendMail(String from, String to) {
        return Arrays.binarySearch(this.ignoreChanges, from + ":" + to) < 0 && Arrays.binarySearch(this.ignoreChanges, "*:" + to) < 0 && Arrays.binarySearch(this.ignoreChanges, from + ":*") < 0;
    }

    public void setSender(JavaMailSender sender) {
        this.sender = sender;
    }

    public void setTo(String[] to) {
        this.to = to;
    }

    public void setCc(String[] cc) {
        this.cc = cc;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setSubject(String subject) {
        this.subject = this.parser.parseExpression(subject, ParserContext.TEMPLATE_EXPRESSION);
    }

    public void setText(String text) {
        this.text = this.parser.parseExpression(text, ParserContext.TEMPLATE_EXPRESSION);
    }

    public void setIgnoreChanges(String[] ignoreChanges) {
        Object[] copy = Arrays.copyOf(ignoreChanges, ignoreChanges.length);
        Arrays.sort(copy);
        this.ignoreChanges = copy;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

