/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.journal;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.codecentric.boot.admin.event.ClientApplicationDeregisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.event.ClientApplicationRegisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.model.Application;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class JournaledEvent {
    private final Type type;
    private final long timestamp;
    private final Application application;
    private final Map<String, Object> data;

    private JournaledEvent(Type type, long timestamp, Application application, Map<String, Object> data) {
        this.type = type;
        this.timestamp = timestamp;
        this.application = application;
        this.data = data != null ? Collections.unmodifiableMap(new HashMap<String, Object>(data)) : Collections.emptyMap();
    }

    public static JournaledEvent fromEvent(ClientApplicationEvent event) {
        long timestamp = event.getTimestamp();
        Application application = event.getApplication();
        if (event instanceof ClientApplicationRegisteredEvent) {
            return new JournaledEvent(Type.REGISTRATION, timestamp, application, null);
        }
        if (event instanceof ClientApplicationDeregisteredEvent) {
            return new JournaledEvent(Type.DEREGISTRATION, timestamp, application, null);
        }
        if (event instanceof ClientApplicationStatusChangedEvent) {
            ClientApplicationStatusChangedEvent changeEvent = (ClientApplicationStatusChangedEvent)event;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("from", changeEvent.getFrom().getStatus());
            data.put("to", changeEvent.getTo().getStatus());
            return new JournaledEvent(Type.STATUS_CHANGE, timestamp, application, data);
        }
        throw new IllegalArgumentException("Couldn't convert event to JournaledEvent: " + event.toString());
    }

    public Application getApplication() {
        return this.application;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "JournaledEvent [type=" + (Object)((Object)this.type) + ", timestamp=" + this.timestamp + ", application=" + this.application + ", data=" + this.data + "]";
    }

    public static enum Type {
        REGISTRATION,
        DEREGISTRATION,
        STATUS_CHANGE;

    }
}

