/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import com.netflix.zuul.ZuulFilter;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import de.codecentric.boot.admin.zuul.ApplicationRouteLocator;
import de.codecentric.boot.admin.zuul.ApplicationRouteRefreshListener;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.zuul.RoutesEndpoint;
import org.springframework.cloud.netflix.zuul.ZuulFilterInitializer;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.ProxyRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.post.SendErrorFilter;
import org.springframework.cloud.netflix.zuul.filters.post.SendResponseFilter;
import org.springframework.cloud.netflix.zuul.filters.pre.DebugFilter;
import org.springframework.cloud.netflix.zuul.filters.pre.FormBodyWrapperFilter;
import org.springframework.cloud.netflix.zuul.filters.pre.PreDecorationFilter;
import org.springframework.cloud.netflix.zuul.filters.pre.Servlet30WrapperFilter;
import org.springframework.cloud.netflix.zuul.filters.route.SimpleHostRoutingFilter;
import org.springframework.cloud.netflix.zuul.web.ZuulController;
import org.springframework.cloud.netflix.zuul.web.ZuulHandlerMapping;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ZuulProperties.class})
public class RevereseZuulProxyConfiguration {
    @Autowired(required=false)
    private TraceRepository traces;
    @Autowired
    private ZuulProperties zuulProperties;
    @Autowired
    private ServerProperties server;
    @Autowired
    private ApplicationRegistry registry;

    @Bean
    public ApplicationRouteLocator routeLocator() {
        return new ApplicationRouteLocator(this.server.getServletPrefix(), this.registry, this.zuulProperties, "/api/applications");
    }

    @Bean
    public PreDecorationFilter preDecorationFilter() {
        return new PreDecorationFilter((ProxyRouteLocator)this.routeLocator(), this.zuulProperties.isAddProxyHeaders());
    }

    @Bean
    public SimpleHostRoutingFilter simpleHostRoutingFilter() {
        ProxyRequestHelper helper = new ProxyRequestHelper();
        if (this.traces != null) {
            helper.setTraces(this.traces);
        }
        return new SimpleHostRoutingFilter(helper);
    }

    @Bean
    public ZuulController zuulController() {
        return new ZuulController();
    }

    @Bean
    public ZuulHandlerMapping zuulHandlerMapping(RouteLocator routes) {
        return new ZuulHandlerMapping(routes, this.zuulController());
    }

    @Bean
    public FormBodyWrapperFilter formBodyWrapperFilter() {
        return new FormBodyWrapperFilter();
    }

    @Bean
    public DebugFilter debugFilter() {
        return new DebugFilter();
    }

    @Bean
    public Servlet30WrapperFilter servlet30WrapperFilter() {
        return new Servlet30WrapperFilter();
    }

    @Bean
    public SendResponseFilter sendResponseFilter() {
        return new SendResponseFilter();
    }

    @Bean
    public SendErrorFilter sendErrorFilter() {
        return new SendErrorFilter();
    }

    @Bean
    public ApplicationRouteRefreshListener applicationRouteRefreshListener() {
        return new ApplicationRouteRefreshListener(this.routeLocator(), this.zuulHandlerMapping((RouteLocator)this.routeLocator()));
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class RoutesEndpointConfiguration {
        @Autowired
        private ProxyRouteLocator routeLocator;

        protected RoutesEndpointConfiguration() {
        }

        @Bean
        public RoutesEndpoint zuulEndpoint() {
            return new RoutesEndpoint(this.routeLocator);
        }
    }

    @Configuration
    protected static class ZuulFilterConfiguration {
        @Autowired
        private Map<String, ZuulFilter> filters;

        protected ZuulFilterConfiguration() {
        }

        @Bean
        public ZuulFilterInitializer zuulFilterInitializer() {
            return new ZuulFilterInitializer(this.filters);
        }
    }
}

