/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import com.hazelcast.config.Config;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import de.codecentric.boot.admin.event.ClientApplicationDeregisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationRegisteredEvent;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import de.codecentric.boot.admin.registry.store.HazelcastApplicationStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Hazelcast.class})
@ConditionalOnProperty(prefix="spring.boot.admin.hazelcast", name={"enabled"}, matchIfMissing=true)
public class HazelcastStoreConfiguration {
    @Value(value="${spring.boot.admin.hazelcast.map:spring-boot-admin-application-store}")
    private String hazelcastMapName;

    @Bean
    @ConditionalOnMissingBean
    public Config hazelcastConfig() {
        return new Config();
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean
    public HazelcastInstance hazelcastInstance(Config hazelcastConfig) {
        return Hazelcast.newHazelcastInstance((Config)hazelcastConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationStore applicationStore(HazelcastInstance hazelcast) {
        IMap map = hazelcast.getMap(this.hazelcastMapName);
        map.addIndex("name", false);
        map.addEntryListener(this.entryListener(), false);
        return new HazelcastApplicationStore((IMap<String, Application>)map);
    }

    @Bean
    public EntryListener<String, Application> entryListener() {
        return new ApplicationEntryListener();
    }

    private static class ApplicationEntryListener
    implements EntryListener<String, Application> {
        @Autowired
        ApplicationEventPublisher publisher;

        private ApplicationEntryListener() {
        }

        public void entryAdded(EntryEvent<String, Application> event) {
            this.publisher.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, (Application)event.getValue()));
        }

        public void entryRemoved(EntryEvent<String, Application> event) {
            this.publisher.publishEvent((ApplicationEvent)new ClientApplicationDeregisteredEvent(this, (Application)event.getValue()));
        }

        public void entryUpdated(EntryEvent<String, Application> event) {
            this.publisher.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, (Application)event.getValue()));
        }

        public void entryEvicted(EntryEvent<String, Application> event) {
            this.publisher.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, null));
        }

        public void mapEvicted(MapEvent event) {
            this.publisher.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, null));
        }

        public void mapCleared(MapEvent event) {
            this.publisher.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, null));
        }
    }
}

