/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.discovery.ApplicationDiscoveryListener;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DiscoveryClient.class})
@ConditionalOnProperty(prefix="spring.boot.admin.discovery", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={NoopDiscoveryClientAutoConfiguration.class})
public class DiscoveryClientConfiguration {
    @Value(value="${spring.boot.admin.discovery.management.context-path:}")
    private String managementPath;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private ApplicationRegistry registry;

    @Bean
    ApplicationListener<ApplicationEvent> applicationDiscoveryListener() {
        ApplicationDiscoveryListener listener = new ApplicationDiscoveryListener(this.discoveryClient, this.registry);
        listener.setManagementContextPath(this.managementPath);
        return listener;
    }
}

