/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.codecentric.boot.admin.config.DiscoveryClientConfiguration;
import de.codecentric.boot.admin.config.HazelcastStoreConfiguration;
import de.codecentric.boot.admin.config.MailNotifierConfiguration;
import de.codecentric.boot.admin.config.RevereseZuulProxyConfiguration;
import de.codecentric.boot.admin.config.SimpleStoreConfig;
import de.codecentric.boot.admin.controller.JournalController;
import de.codecentric.boot.admin.controller.RegistryController;
import de.codecentric.boot.admin.event.ClientApplicationRegisteredEvent;
import de.codecentric.boot.admin.journal.ApplicationEventJournal;
import de.codecentric.boot.admin.journal.store.JournaledEventStore;
import de.codecentric.boot.admin.journal.store.SimpleJournaledEventStore;
import de.codecentric.boot.admin.registry.ApplicationIdGenerator;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import de.codecentric.boot.admin.registry.HashingApplicationUrlIdGenerator;
import de.codecentric.boot.admin.registry.StatusUpdater;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@Import(value={RevereseZuulProxyConfiguration.class, MailNotifierConfiguration.class, HazelcastStoreConfiguration.class, SimpleStoreConfig.class, DiscoveryClientConfiguration.class})
public class AdminServerWebConfiguration
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        if (!this.hasConverter(converters, MappingJackson2HttpMessageConverter.class)) {
            ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().applicationContext(this.applicationContext).build();
            converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(objectMapper));
        }
    }

    private boolean hasConverter(List<HttpMessageConverter<?>> converters, Class<? extends HttpMessageConverter<?>> clazz) {
        for (HttpMessageConverter<?> converter : converters) {
            if (!clazz.isInstance(converter)) continue;
            return true;
        }
        return false;
    }

    @Bean
    public RegistryController registryController(ApplicationRegistry registry) {
        return new RegistryController(registry);
    }

    @Bean
    public ApplicationRegistry applicationRegistry(ApplicationStore applicationStore, ApplicationIdGenerator applicationIdGenerator) {
        return new ApplicationRegistry(applicationStore, applicationIdGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationIdGenerator applicationIdGenerator() {
        return new HashingApplicationUrlIdGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="spring.boot.admin.monitor")
    public StatusUpdater statusUpdater(ApplicationStore store) {
        RestTemplate template = new RestTemplate();
        template.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        template.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            protected boolean hasError(HttpStatus statusCode) {
                return false;
            }
        });
        return new StatusUpdater(template, store);
    }

    @Bean
    public ApplicationListener<ClientApplicationRegisteredEvent> updateRegistrationListener(final StatusUpdater updater) {
        return new ApplicationListener<ClientApplicationRegisteredEvent>(){

            public void onApplicationEvent(ClientApplicationRegisteredEvent event) {
                updater.updateStatus(event.getApplication());
            }
        };
    }

    @Bean
    public ScheduledTaskRegistrar updateTaskRegistrar(final StatusUpdater updater, @Value(value="${spring.boot.admin.monitor.period:10000}") long monitorPeriod) {
        ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
        Runnable registratorTask = new Runnable(){

            @Override
            public void run() {
                updater.updateStatusForAllApplications();
            }
        };
        registrar.addFixedRateTask(registratorTask, monitorPeriod);
        return registrar;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationEventJournal applicationEventJournal(JournaledEventStore store) {
        return new ApplicationEventJournal(store);
    }

    @Bean
    @ConditionalOnMissingBean
    public JournaledEventStore journaledEventStore() {
        return new SimpleJournaledEventStore();
    }

    @Bean
    @ConditionalOnMissingBean
    public JournalController journalController(ApplicationEventJournal eventJournal) {
        return new JournalController(eventJournal);
    }
}

