/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.zuul;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import java.util.LinkedHashMap;
import org.springframework.cloud.netflix.zuul.filters.ProxyRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.util.StringUtils;

public class ApplicationRouteLocator
extends ProxyRouteLocator {
    private ApplicationRegistry registry;
    private String prefix;

    public ApplicationRouteLocator(String servletPath, ApplicationRegistry registry, ZuulProperties properties, String prefix) {
        super(servletPath, null, properties);
        this.registry = registry;
        this.prefix = prefix;
    }

    protected LinkedHashMap<String, ZuulProperties.ZuulRoute> locateRoutes() {
        LinkedHashMap locateRoutes = super.locateRoutes();
        if (this.registry != null) {
            for (Application application : this.registry.getApplications()) {
                this.addRoute(locateRoutes, this.prefix + "/" + application.getId() + "/health/**", application.getHealthUrl());
                if (StringUtils.isEmpty((Object)application.getManagementUrl())) continue;
                this.addRoute(locateRoutes, this.prefix + "/" + application.getId() + "/*/**", application.getManagementUrl());
            }
        }
        return locateRoutes;
    }

    private void addRoute(LinkedHashMap<String, ZuulProperties.ZuulRoute> locateRoutes, String path, String url) {
        locateRoutes.put(path, new ZuulProperties.ZuulRoute(path, url));
    }
}

