/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.registry;

import de.codecentric.boot.admin.event.ClientApplicationRegisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationUnregisteredEvent;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationIdGenerator;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ApplicationRegistry
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRegistry.class);
    private final ApplicationStore store;
    private final ApplicationIdGenerator generator;
    private ApplicationContext context;

    public ApplicationRegistry(ApplicationStore store, ApplicationIdGenerator generator) {
        this.store = store;
        this.generator = generator;
    }

    public Application register(Application app) {
        Assert.notNull((Object)app, (String)"Application must not be null");
        Assert.hasText((String)app.getName(), (String)"Name must not be null");
        Assert.hasText((String)app.getHealthUrl(), (String)"Health-URL must not be null");
        Assert.isTrue((boolean)this.checkUrl(app.getHealthUrl()), (String)"Health-URL is not valid");
        Assert.isTrue((StringUtils.isEmpty((Object)app.getManagementUrl()) || this.checkUrl(app.getManagementUrl()) ? 1 : 0) != 0, (String)"URL is not valid");
        Assert.isTrue((StringUtils.isEmpty((Object)app.getServiceUrl()) || this.checkUrl(app.getServiceUrl()) ? 1 : 0) != 0, (String)"URL is not valid");
        String applicationId = this.generator.generateId(app);
        Validate.notNull((Object)applicationId, (String)"ID must not be null", (Object[])new Object[0]);
        Application newApp = new Application(app.getHealthUrl(), app.getManagementUrl(), app.getServiceUrl(), app.getName(), applicationId);
        Application oldApp = this.store.save(newApp);
        if (oldApp == null) {
            LOGGER.info("New Application {} registered ", (Object)newApp);
            this.context.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, newApp));
        } else if (newApp.getId().equals(oldApp.getId()) && app.getName().equals(oldApp.getName())) {
            LOGGER.debug("Application {} refreshed", (Object)newApp);
        } else {
            LOGGER.warn("Application {} replaced by Application {}", (Object)newApp, (Object)oldApp);
        }
        return newApp;
    }

    private boolean checkUrl(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public Collection<Application> getApplications() {
        return this.store.findAll();
    }

    public Collection<Application> getApplicationsByName(String name) {
        return this.store.findByName(name);
    }

    public Application getApplication(String id) {
        return this.store.find(id);
    }

    public Application unregister(String id) {
        Application app = this.store.delete(id);
        if (app != null) {
            LOGGER.info("Application {} unregistered ", (Object)app);
            this.context.publishEvent((ApplicationEvent)new ClientApplicationUnregisteredEvent(this, app));
        }
        return app;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }
}

