/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.config.Config;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.netflix.zuul.ZuulFilter;
import de.codecentric.boot.admin.controller.RegistryController;
import de.codecentric.boot.admin.discovery.ApplicationDiscoveryListener;
import de.codecentric.boot.admin.event.ClientApplicationRegisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationUnregisteredEvent;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationIdGenerator;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import de.codecentric.boot.admin.registry.HashingApplicationUrlIdGenerator;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import de.codecentric.boot.admin.registry.store.HazelcastApplicationStore;
import de.codecentric.boot.admin.registry.store.SimpleApplicationStore;
import de.codecentric.boot.admin.zuul.ApplicationRouteLocator;
import de.codecentric.boot.admin.zuul.ApplicationRouteRefreshListener;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.cloud.netflix.zuul.RoutesEndpoint;
import org.springframework.cloud.netflix.zuul.ZuulFilterInitializer;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.ProxyRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.post.SendErrorFilter;
import org.springframework.cloud.netflix.zuul.filters.post.SendResponseFilter;
import org.springframework.cloud.netflix.zuul.filters.pre.DebugFilter;
import org.springframework.cloud.netflix.zuul.filters.pre.FormBodyWrapperFilter;
import org.springframework.cloud.netflix.zuul.filters.pre.PreDecorationFilter;
import org.springframework.cloud.netflix.zuul.filters.pre.Servlet30WrapperFilter;
import org.springframework.cloud.netflix.zuul.filters.route.SimpleHostRoutingFilter;
import org.springframework.cloud.netflix.zuul.web.ZuulController;
import org.springframework.cloud.netflix.zuul.web.ZuulHandlerMapping;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class AdminServerWebConfiguration
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        if (!this.hasConverter(converters, MappingJackson2HttpMessageConverter.class)) {
            ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().applicationContext(this.applicationContext).build();
            converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(objectMapper));
        }
    }

    private boolean hasConverter(List<HttpMessageConverter<?>> converters, Class<? extends HttpMessageConverter<?>> clazz) {
        for (HttpMessageConverter<?> converter : converters) {
            if (!clazz.isInstance(converter)) continue;
            return true;
        }
        return false;
    }

    @Bean
    public RegistryController registryController(ApplicationRegistry registry) {
        return new RegistryController(registry);
    }

    @Bean
    public ApplicationRegistry applicationRegistry(ApplicationStore applicationStore, ApplicationIdGenerator applicationIdGenerator) {
        return new ApplicationRegistry(applicationStore, applicationIdGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationIdGenerator applicationIdGenerator() {
        return new HashingApplicationUrlIdGenerator();
    }

    @Configuration
    @ConditionalOnClass(value={DiscoveryClient.class})
    @ConditionalOnProperty(prefix="spring.boot.admin.discovery", name={"enabled"}, matchIfMissing=true)
    @AutoConfigureAfter(value={NoopDiscoveryClientAutoConfiguration.class})
    public static class DiscoveryClientConfiguration {
        @Value(value="${spring.boot.admin.discovery.management.context-path:}")
        private String managementPath;
        @Autowired
        private DiscoveryClient discoveryClient;
        @Autowired
        private ApplicationRegistry registry;

        @Bean
        ApplicationListener<ApplicationEvent> applicationDiscoveryListener() {
            ApplicationDiscoveryListener listener = new ApplicationDiscoveryListener(this.discoveryClient, this.registry);
            listener.setManagementContextPath(this.managementPath);
            return listener;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Hazelcast.class})
    @ConditionalOnProperty(prefix="spring.boot.admin.hazelcast", name={"enabled"}, matchIfMissing=true)
    @AutoConfigureBefore(value={SimpleStoreConfig.class})
    public static class HazelcastStoreConfiguration {
        @Value(value="${spring.boot.admin.hazelcast.map:spring-boot-admin-application-store}")
        private String hazelcastMapName;

        @Bean
        @ConditionalOnMissingBean
        public Config hazelcastConfig() {
            return new Config();
        }

        @Bean(destroyMethod="shutdown")
        @ConditionalOnMissingBean
        public HazelcastInstance hazelcastInstance(Config hazelcastConfig) {
            return Hazelcast.newHazelcastInstance((Config)hazelcastConfig);
        }

        @Bean
        @ConditionalOnMissingBean
        public ApplicationStore applicationStore(HazelcastInstance hazelcast) {
            IMap map = hazelcast.getMap(this.hazelcastMapName);
            map.addIndex("name", false);
            map.addEntryListener(this.entryListener(), false);
            return new HazelcastApplicationStore((IMap<String, Application>)map);
        }

        @Bean
        public EntryListener<String, Application> entryListener() {
            return new ApplicationEntryListener();
        }

        private static class ApplicationEntryListener
        implements EntryListener<String, Application> {
            @Autowired
            ApplicationContext context;

            private ApplicationEntryListener() {
            }

            public void entryAdded(EntryEvent<String, Application> event) {
                this.context.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, (Application)event.getValue()));
            }

            public void entryRemoved(EntryEvent<String, Application> event) {
                this.context.publishEvent((ApplicationEvent)new ClientApplicationUnregisteredEvent(this, (Application)event.getValue()));
            }

            public void entryUpdated(EntryEvent<String, Application> event) {
                this.context.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, (Application)event.getValue()));
            }

            public void entryEvicted(EntryEvent<String, Application> event) {
                this.context.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, null));
            }

            public void mapEvicted(MapEvent event) {
                this.context.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, null));
            }

            public void mapCleared(MapEvent event) {
                this.context.publishEvent((ApplicationEvent)new ClientApplicationRegisteredEvent(this, null));
            }
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={ZuulProperties.class})
    public static class RevereseZuulProxyConfiguration {
        @Autowired(required=false)
        private TraceRepository traces;
        @Autowired
        private ZuulProperties zuulProperties;
        @Autowired
        private ServerProperties server;
        @Autowired
        private ApplicationRegistry registry;

        @Bean
        public ApplicationRouteLocator routeLocator() {
            return new ApplicationRouteLocator(this.server.getServletPrefix(), this.registry, this.zuulProperties, "/api/applications");
        }

        @Bean
        public PreDecorationFilter preDecorationFilter() {
            return new PreDecorationFilter((ProxyRouteLocator)this.routeLocator(), this.zuulProperties.isAddProxyHeaders());
        }

        @Bean
        public SimpleHostRoutingFilter simpleHostRoutingFilter() {
            ProxyRequestHelper helper = new ProxyRequestHelper();
            if (this.traces != null) {
                helper.setTraces(this.traces);
            }
            return new SimpleHostRoutingFilter(helper);
        }

        @Bean
        public ZuulController zuulController() {
            return new ZuulController();
        }

        @Bean
        public ZuulHandlerMapping zuulHandlerMapping(RouteLocator routes) {
            return new ZuulHandlerMapping(routes, this.zuulController());
        }

        @Bean
        public FormBodyWrapperFilter formBodyWrapperFilter() {
            return new FormBodyWrapperFilter();
        }

        @Bean
        public DebugFilter debugFilter() {
            return new DebugFilter();
        }

        @Bean
        public Servlet30WrapperFilter servlet30WrapperFilter() {
            return new Servlet30WrapperFilter();
        }

        @Bean
        public SendResponseFilter sendResponseFilter() {
            return new SendResponseFilter();
        }

        @Bean
        public SendErrorFilter sendErrorFilter() {
            return new SendErrorFilter();
        }

        @Bean
        public ApplicationRouteRefreshListener applicationRouteRefreshListener() {
            return new ApplicationRouteRefreshListener(this.routeLocator(), this.zuulHandlerMapping((RouteLocator)this.routeLocator()));
        }

        @Configuration
        @ConditionalOnClass(value={Endpoint.class})
        protected static class RoutesEndpointConfiguration {
            @Autowired
            private ProxyRouteLocator routeLocator;

            protected RoutesEndpointConfiguration() {
            }

            @Bean
            public RoutesEndpoint zuulEndpoint() {
                return new RoutesEndpoint(this.routeLocator);
            }
        }

        @Configuration
        protected static class ZuulFilterConfiguration {
            @Autowired
            private Map<String, ZuulFilter> filters;

            protected ZuulFilterConfiguration() {
            }

            @Bean
            public ZuulFilterInitializer zuulFilterInitializer() {
                return new ZuulFilterInitializer(this.filters);
            }
        }
    }

    @Configuration
    public static class SimpleStoreConfig {
        @Bean
        @ConditionalOnMissingBean
        public ApplicationStore applicationStore() {
            return new SimpleApplicationStore();
        }
    }
}

