/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.config;

import de.codecentric.boot.admin.server.ui.web.UiController;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.http.CacheControl;
import org.springframework.lang.Nullable;

@ConfigurationProperties(value="spring.boot.admin.ui")
public class AdminServerUiProperties {
    private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/META-INF/spring-boot-admin-server-ui/"};
    private static final String[] CLASSPATH_EXTENSION_RESOURCE_LOCATIONS = new String[]{"classpath:/META-INF/spring-boot-admin-server-ui/extensions/"};
    private String[] resourceLocations = CLASSPATH_RESOURCE_LOCATIONS;
    private String[] extensionResourceLocations = CLASSPATH_EXTENSION_RESOURCE_LOCATIONS;
    private String templateLocation = CLASSPATH_RESOURCE_LOCATIONS[0];
    private String loginIcon = "assets/img/icon-spring-boot-admin.svg";
    private String favicon = "assets/img/favicon.png";
    private String faviconDanger = "assets/img/favicon-danger.png";
    private String title = "Spring Boot Admin";
    private String brand = "<img src=\"assets/img/icon-spring-boot-admin.svg\"><span>Spring Boot Admin</span>";
    @Nullable
    private String publicUrl = null;
    private boolean cacheTemplates = true;
    private Cache cache = new Cache();
    private List<UiController.ExternalView> externalViews = new ArrayList<UiController.ExternalView>();
    private List<UiController.ViewSettings> viewSettings = new ArrayList<UiController.ViewSettings>();
    private boolean rememberMeEnabled = true;
    private List<String> availableLanguages = new ArrayList<String>();
    private PollTimer pollTimer = new PollTimer();
    private List<String> additionalRouteExcludes = new ArrayList<String>();
    private Boolean enableToasts = false;
    private UiTheme theme = new UiTheme();

    public String[] getResourceLocations() {
        return this.resourceLocations;
    }

    public String[] getExtensionResourceLocations() {
        return this.extensionResourceLocations;
    }

    public String getTemplateLocation() {
        return this.templateLocation;
    }

    public String getLoginIcon() {
        return this.loginIcon;
    }

    public String getFavicon() {
        return this.favicon;
    }

    public String getFaviconDanger() {
        return this.faviconDanger;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBrand() {
        return this.brand;
    }

    @Nullable
    public String getPublicUrl() {
        return this.publicUrl;
    }

    public boolean isCacheTemplates() {
        return this.cacheTemplates;
    }

    public Cache getCache() {
        return this.cache;
    }

    public List<UiController.ExternalView> getExternalViews() {
        return this.externalViews;
    }

    public List<UiController.ViewSettings> getViewSettings() {
        return this.viewSettings;
    }

    public boolean isRememberMeEnabled() {
        return this.rememberMeEnabled;
    }

    public List<String> getAvailableLanguages() {
        return this.availableLanguages;
    }

    public PollTimer getPollTimer() {
        return this.pollTimer;
    }

    public List<String> getAdditionalRouteExcludes() {
        return this.additionalRouteExcludes;
    }

    public Boolean getEnableToasts() {
        return this.enableToasts;
    }

    public UiTheme getTheme() {
        return this.theme;
    }

    public void setResourceLocations(String[] resourceLocations) {
        this.resourceLocations = resourceLocations;
    }

    public void setExtensionResourceLocations(String[] extensionResourceLocations) {
        this.extensionResourceLocations = extensionResourceLocations;
    }

    public void setTemplateLocation(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    public void setLoginIcon(String loginIcon) {
        this.loginIcon = loginIcon;
    }

    public void setFavicon(String favicon) {
        this.favicon = favicon;
    }

    public void setFaviconDanger(String faviconDanger) {
        this.faviconDanger = faviconDanger;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public void setPublicUrl(@Nullable String publicUrl) {
        this.publicUrl = publicUrl;
    }

    public void setCacheTemplates(boolean cacheTemplates) {
        this.cacheTemplates = cacheTemplates;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setExternalViews(List<UiController.ExternalView> externalViews) {
        this.externalViews = externalViews;
    }

    public void setViewSettings(List<UiController.ViewSettings> viewSettings) {
        this.viewSettings = viewSettings;
    }

    public void setRememberMeEnabled(boolean rememberMeEnabled) {
        this.rememberMeEnabled = rememberMeEnabled;
    }

    public void setAvailableLanguages(List<String> availableLanguages) {
        this.availableLanguages = availableLanguages;
    }

    public void setPollTimer(PollTimer pollTimer) {
        this.pollTimer = pollTimer;
    }

    public void setAdditionalRouteExcludes(List<String> additionalRouteExcludes) {
        this.additionalRouteExcludes = additionalRouteExcludes;
    }

    public void setEnableToasts(Boolean enableToasts) {
        this.enableToasts = enableToasts;
    }

    public void setTheme(UiTheme theme) {
        this.theme = theme;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminServerUiProperties)) {
            return false;
        }
        AdminServerUiProperties other = (AdminServerUiProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCacheTemplates() != other.isCacheTemplates()) {
            return false;
        }
        if (this.isRememberMeEnabled() != other.isRememberMeEnabled()) {
            return false;
        }
        Boolean this$enableToasts = this.getEnableToasts();
        Boolean other$enableToasts = other.getEnableToasts();
        if (this$enableToasts == null ? other$enableToasts != null : !((Object)this$enableToasts).equals(other$enableToasts)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResourceLocations(), other.getResourceLocations())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExtensionResourceLocations(), other.getExtensionResourceLocations())) {
            return false;
        }
        String this$templateLocation = this.getTemplateLocation();
        String other$templateLocation = other.getTemplateLocation();
        if (this$templateLocation == null ? other$templateLocation != null : !this$templateLocation.equals(other$templateLocation)) {
            return false;
        }
        String this$loginIcon = this.getLoginIcon();
        String other$loginIcon = other.getLoginIcon();
        if (this$loginIcon == null ? other$loginIcon != null : !this$loginIcon.equals(other$loginIcon)) {
            return false;
        }
        String this$favicon = this.getFavicon();
        String other$favicon = other.getFavicon();
        if (this$favicon == null ? other$favicon != null : !this$favicon.equals(other$favicon)) {
            return false;
        }
        String this$faviconDanger = this.getFaviconDanger();
        String other$faviconDanger = other.getFaviconDanger();
        if (this$faviconDanger == null ? other$faviconDanger != null : !this$faviconDanger.equals(other$faviconDanger)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$brand = this.getBrand();
        String other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
            return false;
        }
        String this$publicUrl = this.getPublicUrl();
        String other$publicUrl = other.getPublicUrl();
        if (this$publicUrl == null ? other$publicUrl != null : !this$publicUrl.equals(other$publicUrl)) {
            return false;
        }
        Cache this$cache = this.getCache();
        Cache other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        List<UiController.ExternalView> this$externalViews = this.getExternalViews();
        List<UiController.ExternalView> other$externalViews = other.getExternalViews();
        if (this$externalViews == null ? other$externalViews != null : !((Object)this$externalViews).equals(other$externalViews)) {
            return false;
        }
        List<UiController.ViewSettings> this$viewSettings = this.getViewSettings();
        List<UiController.ViewSettings> other$viewSettings = other.getViewSettings();
        if (this$viewSettings == null ? other$viewSettings != null : !((Object)this$viewSettings).equals(other$viewSettings)) {
            return false;
        }
        List<String> this$availableLanguages = this.getAvailableLanguages();
        List<String> other$availableLanguages = other.getAvailableLanguages();
        if (this$availableLanguages == null ? other$availableLanguages != null : !((Object)this$availableLanguages).equals(other$availableLanguages)) {
            return false;
        }
        PollTimer this$pollTimer = this.getPollTimer();
        PollTimer other$pollTimer = other.getPollTimer();
        if (this$pollTimer == null ? other$pollTimer != null : !((Object)this$pollTimer).equals(other$pollTimer)) {
            return false;
        }
        List<String> this$additionalRouteExcludes = this.getAdditionalRouteExcludes();
        List<String> other$additionalRouteExcludes = other.getAdditionalRouteExcludes();
        if (this$additionalRouteExcludes == null ? other$additionalRouteExcludes != null : !((Object)this$additionalRouteExcludes).equals(other$additionalRouteExcludes)) {
            return false;
        }
        UiTheme this$theme = this.getTheme();
        UiTheme other$theme = other.getTheme();
        return !(this$theme == null ? other$theme != null : !((Object)this$theme).equals(other$theme));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdminServerUiProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCacheTemplates() ? 79 : 97);
        result = result * 59 + (this.isRememberMeEnabled() ? 79 : 97);
        Boolean $enableToasts = this.getEnableToasts();
        result = result * 59 + ($enableToasts == null ? 43 : ((Object)$enableToasts).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getResourceLocations());
        result = result * 59 + Arrays.deepHashCode(this.getExtensionResourceLocations());
        String $templateLocation = this.getTemplateLocation();
        result = result * 59 + ($templateLocation == null ? 43 : $templateLocation.hashCode());
        String $loginIcon = this.getLoginIcon();
        result = result * 59 + ($loginIcon == null ? 43 : $loginIcon.hashCode());
        String $favicon = this.getFavicon();
        result = result * 59 + ($favicon == null ? 43 : $favicon.hashCode());
        String $faviconDanger = this.getFaviconDanger();
        result = result * 59 + ($faviconDanger == null ? 43 : $faviconDanger.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
        String $publicUrl = this.getPublicUrl();
        result = result * 59 + ($publicUrl == null ? 43 : $publicUrl.hashCode());
        Cache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        List<UiController.ExternalView> $externalViews = this.getExternalViews();
        result = result * 59 + ($externalViews == null ? 43 : ((Object)$externalViews).hashCode());
        List<UiController.ViewSettings> $viewSettings = this.getViewSettings();
        result = result * 59 + ($viewSettings == null ? 43 : ((Object)$viewSettings).hashCode());
        List<String> $availableLanguages = this.getAvailableLanguages();
        result = result * 59 + ($availableLanguages == null ? 43 : ((Object)$availableLanguages).hashCode());
        PollTimer $pollTimer = this.getPollTimer();
        result = result * 59 + ($pollTimer == null ? 43 : ((Object)$pollTimer).hashCode());
        List<String> $additionalRouteExcludes = this.getAdditionalRouteExcludes();
        result = result * 59 + ($additionalRouteExcludes == null ? 43 : ((Object)$additionalRouteExcludes).hashCode());
        UiTheme $theme = this.getTheme();
        result = result * 59 + ($theme == null ? 43 : ((Object)$theme).hashCode());
        return result;
    }

    public String toString() {
        return "AdminServerUiProperties(resourceLocations=" + Arrays.deepToString(this.getResourceLocations()) + ", extensionResourceLocations=" + Arrays.deepToString(this.getExtensionResourceLocations()) + ", templateLocation=" + this.getTemplateLocation() + ", loginIcon=" + this.getLoginIcon() + ", favicon=" + this.getFavicon() + ", faviconDanger=" + this.getFaviconDanger() + ", title=" + this.getTitle() + ", brand=" + this.getBrand() + ", publicUrl=" + this.getPublicUrl() + ", cacheTemplates=" + this.isCacheTemplates() + ", cache=" + this.getCache() + ", externalViews=" + this.getExternalViews() + ", viewSettings=" + this.getViewSettings() + ", rememberMeEnabled=" + this.isRememberMeEnabled() + ", availableLanguages=" + this.getAvailableLanguages() + ", pollTimer=" + this.getPollTimer() + ", additionalRouteExcludes=" + this.getAdditionalRouteExcludes() + ", enableToasts=" + this.getEnableToasts() + ", theme=" + this.getTheme() + ")";
    }

    public static class Cache {
        @Nullable
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration maxAge = Duration.ofSeconds(3600L);
        private Boolean noCache = false;
        private Boolean noStore = false;

        public CacheControl toCacheControl() {
            if (Boolean.TRUE.equals(this.noStore)) {
                return CacheControl.noStore();
            }
            if (Boolean.TRUE.equals(this.noCache)) {
                return CacheControl.noCache();
            }
            if (this.maxAge != null) {
                return CacheControl.maxAge((long)this.maxAge.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
            }
            return CacheControl.empty();
        }

        @Nullable
        public Duration getMaxAge() {
            return this.maxAge;
        }

        public Boolean getNoCache() {
            return this.noCache;
        }

        public Boolean getNoStore() {
            return this.noStore;
        }

        public void setMaxAge(@Nullable Duration maxAge) {
            this.maxAge = maxAge;
        }

        public void setNoCache(Boolean noCache) {
            this.noCache = noCache;
        }

        public void setNoStore(Boolean noStore) {
            this.noStore = noStore;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cache)) {
                return false;
            }
            Cache other = (Cache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$noCache = this.getNoCache();
            Boolean other$noCache = other.getNoCache();
            if (this$noCache == null ? other$noCache != null : !((Object)this$noCache).equals(other$noCache)) {
                return false;
            }
            Boolean this$noStore = this.getNoStore();
            Boolean other$noStore = other.getNoStore();
            if (this$noStore == null ? other$noStore != null : !((Object)this$noStore).equals(other$noStore)) {
                return false;
            }
            Duration this$maxAge = this.getMaxAge();
            Duration other$maxAge = other.getMaxAge();
            return !(this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $noCache = this.getNoCache();
            result = result * 59 + ($noCache == null ? 43 : ((Object)$noCache).hashCode());
            Boolean $noStore = this.getNoStore();
            result = result * 59 + ($noStore == null ? 43 : ((Object)$noStore).hashCode());
            Duration $maxAge = this.getMaxAge();
            result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
            return result;
        }

        public String toString() {
            return "AdminServerUiProperties.Cache(maxAge=" + this.getMaxAge() + ", noCache=" + this.getNoCache() + ", noStore=" + this.getNoStore() + ")";
        }
    }

    public static class PollTimer {
        private int cache = 2500;
        private int datasource = 2500;
        private int gc = 2500;
        private int process = 2500;
        private int memory = 2500;
        private int threads = 2500;

        public int getCache() {
            return this.cache;
        }

        public int getDatasource() {
            return this.datasource;
        }

        public int getGc() {
            return this.gc;
        }

        public int getProcess() {
            return this.process;
        }

        public int getMemory() {
            return this.memory;
        }

        public int getThreads() {
            return this.threads;
        }

        public void setCache(int cache) {
            this.cache = cache;
        }

        public void setDatasource(int datasource) {
            this.datasource = datasource;
        }

        public void setGc(int gc) {
            this.gc = gc;
        }

        public void setProcess(int process) {
            this.process = process;
        }

        public void setMemory(int memory) {
            this.memory = memory;
        }

        public void setThreads(int threads) {
            this.threads = threads;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PollTimer)) {
                return false;
            }
            PollTimer other = (PollTimer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCache() != other.getCache()) {
                return false;
            }
            if (this.getDatasource() != other.getDatasource()) {
                return false;
            }
            if (this.getGc() != other.getGc()) {
                return false;
            }
            if (this.getProcess() != other.getProcess()) {
                return false;
            }
            if (this.getMemory() != other.getMemory()) {
                return false;
            }
            return this.getThreads() == other.getThreads();
        }

        protected boolean canEqual(Object other) {
            return other instanceof PollTimer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCache();
            result = result * 59 + this.getDatasource();
            result = result * 59 + this.getGc();
            result = result * 59 + this.getProcess();
            result = result * 59 + this.getMemory();
            result = result * 59 + this.getThreads();
            return result;
        }

        public String toString() {
            return "AdminServerUiProperties.PollTimer(cache=" + this.getCache() + ", datasource=" + this.getDatasource() + ", gc=" + this.getGc() + ", process=" + this.getProcess() + ", memory=" + this.getMemory() + ", threads=" + this.getThreads() + ")";
        }
    }

    public static class UiTheme {
        private Boolean backgroundEnabled = true;
        private Palette palette = new Palette();
        private String color = "#14615A";

        public Boolean getBackgroundEnabled() {
            return this.backgroundEnabled;
        }

        public Palette getPalette() {
            return this.palette;
        }

        public String getColor() {
            return this.color;
        }

        public void setBackgroundEnabled(Boolean backgroundEnabled) {
            this.backgroundEnabled = backgroundEnabled;
        }

        public void setPalette(Palette palette) {
            this.palette = palette;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UiTheme)) {
                return false;
            }
            UiTheme other = (UiTheme)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$backgroundEnabled = this.getBackgroundEnabled();
            Boolean other$backgroundEnabled = other.getBackgroundEnabled();
            if (this$backgroundEnabled == null ? other$backgroundEnabled != null : !((Object)this$backgroundEnabled).equals(other$backgroundEnabled)) {
                return false;
            }
            Palette this$palette = this.getPalette();
            Palette other$palette = other.getPalette();
            if (this$palette == null ? other$palette != null : !this$palette.equals(other$palette)) {
                return false;
            }
            String this$color = this.getColor();
            String other$color = other.getColor();
            return !(this$color == null ? other$color != null : !this$color.equals(other$color));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UiTheme;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $backgroundEnabled = this.getBackgroundEnabled();
            result = result * 59 + ($backgroundEnabled == null ? 43 : ((Object)$backgroundEnabled).hashCode());
            Palette $palette = this.getPalette();
            result = result * 59 + ($palette == null ? 43 : $palette.hashCode());
            String $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : $color.hashCode());
            return result;
        }

        public String toString() {
            return "AdminServerUiProperties.UiTheme(backgroundEnabled=" + this.getBackgroundEnabled() + ", palette=" + this.getPalette() + ", color=" + this.getColor() + ")";
        }
    }

    public static class Palette {
        private String shade50 = "#EEFCFA";
        private String shade100 = "#D9F7F4";
        private String shade200 = "#B7F0EA";
        private String shade300 = "#91E8E0";
        private String shade400 = "#6BE0D5";
        private String shade500 = "#47D9CB";
        private String shade600 = "#27BEAF";
        private String shade700 = "#1E9084";
        private String shade800 = "#14615A";
        private String shade900 = "#0A2F2B";

        public void set50(String shade50) {
            this.shade50 = shade50;
        }

        public void set100(String shade100) {
            this.shade100 = shade100;
        }

        public void set200(String shade200) {
            this.shade200 = shade200;
        }

        public void set300(String shade300) {
            this.shade300 = shade300;
        }

        public void set400(String shade400) {
            this.shade400 = shade400;
        }

        public void set500(String shade500) {
            this.shade500 = shade500;
        }

        public void set600(String shade600) {
            this.shade600 = shade600;
        }

        public void set700(String shade700) {
            this.shade700 = shade700;
        }

        public void set800(String shade800) {
            this.shade800 = shade800;
        }

        public void set900(String shade900) {
            this.shade900 = shade900;
        }

        public String getShade50() {
            return this.shade50;
        }

        public String getShade100() {
            return this.shade100;
        }

        public String getShade200() {
            return this.shade200;
        }

        public String getShade300() {
            return this.shade300;
        }

        public String getShade400() {
            return this.shade400;
        }

        public String getShade500() {
            return this.shade500;
        }

        public String getShade600() {
            return this.shade600;
        }

        public String getShade700() {
            return this.shade700;
        }

        public String getShade800() {
            return this.shade800;
        }

        public String getShade900() {
            return this.shade900;
        }
    }
}

