/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin;

import de.codecentric.boot.admin.server.config.AdminServerProperties;
import de.codecentric.boot.admin.server.config.EnableAdminServer;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.notify.LoggingNotifier;
import java.net.URI;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.RedirectServerLogoutSuccessHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;

@Configuration(proxyBeanMethods=false)
@EnableAutoConfiguration
@EnableAdminServer
public class SpringBootAdminReactiveApplication {
    private final AdminServerProperties adminServer;

    public SpringBootAdminReactiveApplication(AdminServerProperties adminServer) {
        this.adminServer = adminServer;
    }

    public static void main(String[] args) {
        SpringApplication.run(SpringBootAdminReactiveApplication.class, (String[])args);
    }

    @Bean
    @Profile(value={"insecure"})
    public SecurityWebFilterChain securityWebFilterChainPermitAll(ServerHttpSecurity http) {
        return http.authorizeExchange(authorizeExchange -> authorizeExchange.anyExchange().permitAll()).csrf(ServerHttpSecurity.CsrfSpec::disable).build();
    }

    @Bean
    @Profile(value={"secure"})
    public SecurityWebFilterChain securityWebFilterChainSecure(ServerHttpSecurity http) {
        return http.authorizeExchange(authorizeExchange -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchange.pathMatchers(new String[]{this.adminServer.path("/assets/**")})).permitAll().pathMatchers(new String[]{"/actuator/health/**"})).permitAll().pathMatchers(new String[]{this.adminServer.path("/login")})).permitAll().anyExchange().authenticated()).formLogin(formLogin -> formLogin.loginPage(this.adminServer.path("/login")).authenticationSuccessHandler(this.loginSuccessHandler(this.adminServer.path("/")))).logout(logout -> logout.logoutUrl(this.adminServer.path("/logout")).logoutSuccessHandler(this.logoutSuccessHandler(this.adminServer.path("/login?logout")))).httpBasic(Customizer.withDefaults()).csrf(ServerHttpSecurity.CsrfSpec::disable).build();
    }

    private ServerLogoutSuccessHandler logoutSuccessHandler(String uri) {
        RedirectServerLogoutSuccessHandler successHandler = new RedirectServerLogoutSuccessHandler();
        successHandler.setLogoutSuccessUrl(URI.create(uri));
        return successHandler;
    }

    private ServerAuthenticationSuccessHandler loginSuccessHandler(String uri) {
        RedirectServerAuthenticationSuccessHandler successHandler = new RedirectServerAuthenticationSuccessHandler();
        successHandler.setLocation(URI.create(uri));
        return successHandler;
    }

    @Bean
    public LoggingNotifier loggerNotifier(InstanceRepository repository) {
        return new LoggingNotifier(repository);
    }
}

