/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin;

import de.codecentric.boot.admin.server.config.AdminServerProperties;
import de.codecentric.boot.admin.server.config.EnableAdminServer;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.notify.LoggingNotifier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;

@Configuration
@EnableAutoConfiguration
@EnableAdminServer
public class SpringBootAdminReactiveApplication {
    private final String adminContextPath;

    public SpringBootAdminReactiveApplication(AdminServerProperties adminServerProperties) {
        this.adminContextPath = adminServerProperties.getContextPath();
    }

    public static void main(String[] args) {
        SpringApplication.run(SpringBootAdminReactiveApplication.class, (String[])args);
    }

    @Bean
    @Profile(value={"insecure"})
    public SecurityWebFilterChain securityWebFilterChainPermitAll(ServerHttpSecurity http) {
        return http.authorizeExchange().anyExchange().permitAll().and().csrf().disable().build();
    }

    @Bean
    @Profile(value={"secure"})
    public SecurityWebFilterChain securityWebFilterChainSecure(ServerHttpSecurity http) {
        return ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.authorizeExchange().pathMatchers(new String[]{this.adminContextPath + "/assets/**"})).permitAll().pathMatchers(new String[]{this.adminContextPath + "/login"})).permitAll().anyExchange().authenticated().and().formLogin().loginPage(this.adminContextPath + "/login").and().logout().logoutUrl(this.adminContextPath + "/logout").and().httpBasic().and().csrf().disable().build();
    }

    @Bean
    public LoggingNotifier loggerNotifier(InstanceRepository repository) {
        return new LoggingNotifier(repository);
    }
}

