(function(global, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? factory(require("vue")) : typeof define === "function" && define.amd ? define(["vue"], factory) : (global = typeof globalThis !== "undefined" ? globalThis : global || self, factory(global.Vue));
})(this, function(vue) {
  "use strict";var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

  const _export_sfc = (sfc, props) => {
    const target = sfc.__vccOpts || sfc;
    for (const [key, val] of props) {
      target[key] = val;
    }
    return target;
  };
  const _sfc_main$3 = {
    props: {
      instance: {
        //<1>
        type: Object,
        required: true
      }
    },
    data: () => ({
      text: ""
    }),
    created() {
      return __async(this, null, function* () {
        console.log(this.instance);
        const response = yield this.instance.axios.get("actuator/custom");
        this.text = response.data;
      });
    }
  };
  const _hoisted_1$3 = { class: "custom" };
  const _hoisted_2$2 = ["textContent"];
  const _hoisted_3$1 = ["innerHTML"];
  function _sfc_render$1(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("div", _hoisted_1$3, [
      vue.createElementVNode("p", null, [
        _cache[0] || (_cache[0] = vue.createTextVNode("Instance: ")),
        vue.createElementVNode("span", {
          textContent: vue.toDisplayString($props.instance.id)
        }, null, 8, _hoisted_2$2)
      ]),
      vue.createElementVNode("p", null, [
        _cache[1] || (_cache[1] = vue.createTextVNode("Output: ")),
        vue.createElementVNode("span", { innerHTML: _ctx.text }, null, 8, _hoisted_3$1)
      ])
    ]);
  }
  const customEndpoint = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["render", _sfc_render$1], ["__scopeId", "data-v-a75e7808"]]);
  const _hoisted_1$2 = { class: "custom" };
  const _hoisted_2$1 = ["textContent"];
  const _sfc_main$2 = {
    __name: "custom-subitem",
    setup(__props) {
      const { t, mergeLocaleMessage } = SBA.useI18n();
      mergeLocaleMessage("en", {
        custom_sub: {
          hello: "Hello from the submenu item"
        }
      });
      mergeLocaleMessage("de", {
        custom_sub: {
          hello: "Hallo, ich bin ein Sub-Menü-Element!"
        }
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", _hoisted_1$2, [
          vue.createElementVNode("h1", {
            textContent: vue.toDisplayString(vue.unref(t)("custom_sub.hello"))
          }, null, 8, _hoisted_2$1)
        ]);
      };
    }
  };
  const customSubitem = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["__scopeId", "data-v-9ec6ea91"]]);
  const _sfc_main$1 = {
    setup() {
      const { applications } = SBA.useApplicationStore();
      return {
        applications
      };
    },
    methods: {
      stringify: JSON.stringify
    }
  };
  const _hoisted_1$1 = { class: "m-4" };
  const _hoisted_2 = ["textContent"];
  const _hoisted_3 = ["textContent"];
  function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_sba_status = vue.resolveComponent("sba-status");
    const _component_sba_tag = vue.resolveComponent("sba-tag");
    const _component_sba_panel = vue.resolveComponent("sba-panel");
    return vue.openBlock(), vue.createElementBlock("div", _hoisted_1$1, [
      (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList($setup.applications, (application) => {
        return vue.openBlock(), vue.createBlock(_component_sba_panel, {
          key: application.name,
          title: application.name
        }, {
          default: vue.withCtx(() => [
            _cache[0] || (_cache[0] = vue.createTextVNode(" This application has the following instances: ")),
            vue.createElementVNode("ul", null, [
              (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(application.instances, (instance) => {
                return vue.openBlock(), vue.createElementBlock("li", null, [
                  vue.createElementVNode("span", {
                    class: "mx-1",
                    textContent: vue.toDisplayString(instance.registration.name)
                  }, null, 8, _hoisted_2),
                  vue.createVNode(_component_sba_status, {
                    status: instance.statusInfo.status,
                    class: "mx-1"
                  }, null, 8, ["status"]),
                  vue.createVNode(_component_sba_tag, {
                    value: instance.id,
                    class: "mx-1",
                    label: "id"
                  }, null, 8, ["value"])
                ]);
              }), 256))
            ])
          ]),
          _: 2
        }, 1032, ["title"]);
      }), 128)),
      vue.createElementVNode("pre", {
        textContent: vue.toDisplayString($setup.applications)
      }, null, 8, _hoisted_3)
    ]);
  }
  const custom = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["render", _sfc_render]]);
  const _hoisted_1 = ["textContent"];
  const _sfc_main = {
    __name: "handle",
    setup(__props) {
      const { applications } = SBA.useApplicationStore();
      const { t } = SBA.useI18n();
      const upCount = vue.computed({
        get() {
          return applications.value.reduce((current, next) => {
            return current + next.instances.filter((instance) => instance.statusInfo.status === "UP").length;
          }, 0);
        }
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("span", null, [
          vue.createElementVNode("span", {
            textContent: vue.toDisplayString(vue.unref(t)("custom.label"))
          }, null, 8, _hoisted_1),
          vue.createElementVNode("span", null, " (UP: " + vue.toDisplayString(upCount.value) + ")", 1)
        ]);
      };
    }
  };
  SBA.use({
    install({ viewRegistry, i18n }) {
      viewRegistry.addView({
        name: "custom",
        //<1>
        path: "/custom",
        //<2>
        component: custom,
        //<3>
        group: "custom",
        //<4>
        handle: _sfc_main,
        //<5>
        order: 1e3
        //<6>
      });
      i18n.mergeLocaleMessage("en", {
        custom: {
          label: "My Extensions"
          //<7>
        }
      });
      i18n.mergeLocaleMessage("de", {
        custom: {
          label: "Meine Erweiterung"
        }
      });
    }
  });
  SBA.viewRegistry.addView({
    name: "customSub",
    parent: "custom",
    // <1>
    path: "/customSub",
    // <2>
    component: customSubitem,
    label: "Custom Sub",
    order: 1e3
  });
  SBA.viewRegistry.addView({
    name: "customSubUser",
    parent: "user",
    // <1>
    path: "/customSub",
    // <2>
    component: customSubitem,
    label: "Custom Sub In Usermenu",
    order: 1e3
  });
  SBA.viewRegistry.addView({
    name: "instances/custom",
    parent: "instances",
    // <1>
    path: "custom",
    component: customEndpoint,
    label: "Custom",
    group: "custom",
    // <2>
    order: 1e3,
    isEnabled: ({ instance }) => {
      return instance.hasEndpoint("custom");
    }
    // <3>
  });
  SBA.viewRegistry.setGroupIcon(
    "custom",
    //<1>
    `<svg xmlns='http://www.w3.org/2000/svg'
        class='h-5  mr-3'
        viewBox='0 0 576 512'><path d='M512 80c8.8 0 16 7.2 16 16V416c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V96c0-8.8 7.2-16 16-16H512zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM200 208c14.2 0 27 6.1 35.8 16c8.8 9.9 24 10.7 33.9 1.9s10.7-24 1.9-33.9c-17.5-19.6-43.1-32-71.5-32c-53 0-96 43-96 96s43 96 96 96c28.4 0 54-12.4 71.5-32c8.8-9.9 8-25-1.9-33.9s-25-8-33.9 1.9c-8.8 9.9-21.6 16-35.8 16c-26.5 0-48-21.5-48-48s21.5-48 48-48zm144 48c0-26.5 21.5-48 48-48c14.2 0 27 6.1 35.8 16c8.8 9.9 24 10.7 33.9 1.9s10.7-24 1.9-33.9c-17.5-19.6-43.1-32-71.5-32c-53 0-96 43-96 96s43 96 96 96c28.4 0 54-12.4 71.5-32c8.8-9.9 8-25-1.9-33.9s-25-8-33.9 1.9c-8.8 9.9-21.6 16-35.8 16c-26.5 0-48-21.5-48-48z'/>
  </svg>`
    //<2>
  );
});
//# sourceMappingURL=custom-ui.js.map
