/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.script.dynamicvalue;

import de.codecentric.reedelk.runtime.api.commons.FunctionNameUUID;
import de.codecentric.reedelk.runtime.api.commons.ModuleContext;
import de.codecentric.reedelk.runtime.api.commons.ScriptUtils;
import de.codecentric.reedelk.runtime.api.script.ScriptBlock;

public abstract class DynamicValue<T>
implements ScriptBlock {
    private final boolean isScript;
    private final ModuleContext context;
    private final String functionNameUUID;
    protected final Object body;

    protected DynamicValue(Object body) {
        if (ScriptUtils.isScript(body)) {
            throw new IllegalStateException(String.format("Script body [%s] was not expected.", body));
        }
        this.body = body;
        this.context = null;
        this.isScript = false;
        this.functionNameUUID = null;
    }

    protected DynamicValue(Object body, ModuleContext context) {
        this.body = body;
        this.context = context;
        this.isScript = ScriptUtils.isScript(body);
        this.functionNameUUID = FunctionNameUUID.generate(context);
    }

    protected DynamicValue(DynamicValue<?> original) {
        this.body = original.body;
        this.context = original.context;
        this.isScript = original.isScript;
        this.functionNameUUID = original.functionNameUUID;
    }

    @Override
    public String functionName() {
        return this.functionNameUUID;
    }

    @Override
    public String body() {
        if (this.isScript) {
            return (String)this.body;
        }
        throw new IllegalStateException("The Dynamic value is not a script");
    }

    @Override
    public boolean isEmpty() {
        if (this.isScript) {
            if (this.body == null) {
                return true;
            }
            return ScriptUtils.isBlank((String)this.body);
        }
        throw new IllegalStateException("The Dynamic value is not a script");
    }

    @Override
    public ModuleContext getContext() {
        if (!this.isScript) {
            throw new IllegalStateException("ScriptContext is only availabl for scripts values");
        }
        return this.context;
    }

    public String toString() {
        return "DynamicValue{functionNameUUID='" + this.functionNameUUID + '\'' + ", body='" + this.body + '\'' + '}';
    }

    public T value() {
        return (T)this.body;
    }

    public boolean isScript() {
        return this.isScript;
    }

    public boolean isNotNull() {
        return this.body instanceof String || this.body != null;
    }

    public abstract Class<T> getEvaluatedType();
}

