/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.script;

import de.codecentric.reedelk.runtime.api.commons.FunctionNameUUID;
import de.codecentric.reedelk.runtime.api.commons.ModuleContext;
import de.codecentric.reedelk.runtime.api.commons.ScriptUtils;
import de.codecentric.reedelk.runtime.api.script.ScriptBlock;

public class Script
implements ScriptBlock {
    private final ModuleContext context;
    private final String scriptFile;
    private final String functionNameUUID;

    public static Script from(String scriptFile, ModuleContext context) {
        if (context == null) {
            throw new IllegalArgumentException("context");
        }
        return new Script(scriptFile, context);
    }

    protected Script(String scriptFile, ModuleContext context) {
        this.context = context;
        this.scriptFile = scriptFile;
        this.functionNameUUID = FunctionNameUUID.generate(context);
    }

    @Override
    public String functionName() {
        return this.functionNameUUID;
    }

    @Override
    public boolean isEmpty() {
        return ScriptUtils.isBlank(this.body());
    }

    @Override
    public String body() {
        throw new UnsupportedOperationException("implemented in the proxy");
    }

    @Override
    public ModuleContext getContext() {
        return this.context;
    }

    public String getScriptPath() {
        return this.scriptFile;
    }
}

