/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.message.content;

import de.codecentric.reedelk.runtime.api.annotation.Type;
import de.codecentric.reedelk.runtime.api.annotation.TypeFunction;
import de.codecentric.reedelk.runtime.api.message.MessagePayload;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.message.content.TypedPublisher;
import java.io.Serializable;

@Type(description="A typed content contains information about the payload which encapsulates. Information provided by type are payload type (e.g String, Object, Collection), mime type (e.g text/plain, image/jpeg), and the actual content data.")
public interface TypedContent<T, StreamType>
extends Serializable {
    @TypeFunction(signature="type()", example="message.content().type()", description="Returns the data type of the content.")
    public Class<T> type();

    default public Class<T> getType() {
        return this.type();
    }

    @TypeFunction(signature="streamType()", example="message.content().streamType()", description="Returns the data type of the stream generated by this content.")
    public Class<StreamType> streamType();

    default public Class<StreamType> getStreamType() {
        return this.streamType();
    }

    @TypeFunction(signature="mimeType()", example="message.content().mimeType()", description="Returns the mime type of the content.")
    public MimeType mimeType();

    default public MimeType getMimeType() {
        return this.mimeType();
    }

    @TypeFunction(returnType=MessagePayload.class, signature="data()", example="message.content().data()", description="Returns the actual data which could be could be a text, a byte array, a collection and so on depending on the component which generated it.")
    public T data();

    default public T getData() {
        return this.data();
    }

    public TypedPublisher<StreamType> stream();

    default public TypedPublisher<StreamType> getStream() {
        return this.stream();
    }

    @TypeFunction(signature="isStream()", example="message.content().isStream()", description="Returns true if this message is a stream, false otherwise.")
    public boolean isStream();

    @TypeFunction(signature="consume()", example="message.content().consume()", description="Consumes the stream of this message by loading the entire stream content in memory.")
    public void consume();
}

