/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.message.content;

import de.codecentric.reedelk.runtime.api.commons.StreamUtils;
import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.message.content.TypedContent;
import de.codecentric.reedelk.runtime.api.message.content.TypedMono;
import de.codecentric.reedelk.runtime.api.message.content.TypedPublisher;
import org.reactivestreams.Publisher;

public class StringContent
implements TypedContent<String, String> {
    private final transient Publisher<String> payloadAsStream;
    private final Class<String> type = String.class;
    private final MimeType mimeType;
    private String payload;
    private boolean consumed;
    private boolean streamReleased = false;

    public StringContent(String payload, MimeType mimeType) {
        this.payloadAsStream = null;
        this.mimeType = mimeType;
        this.payload = payload;
        this.consumed = true;
    }

    public StringContent(Publisher<String> payloadAsStream, MimeType mimeType) {
        this.payloadAsStream = payloadAsStream;
        this.mimeType = mimeType;
        this.consumed = false;
    }

    @Override
    public Class<String> type() {
        return this.type;
    }

    @Override
    public Class<String> streamType() {
        return this.type;
    }

    @Override
    public MimeType mimeType() {
        return this.mimeType;
    }

    @Override
    public String data() {
        this.consumeIfNeeded();
        return this.payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedPublisher<String> stream() {
        if (this.consumed) {
            return TypedMono.just(this.payload);
        }
        StringContent stringContent = this;
        synchronized (stringContent) {
            if (!this.consumed) {
                if (this.streamReleased) {
                    throw new PlatformException("Stream has been already released. This payload cannot be consumed anymore.");
                }
                this.streamReleased = true;
                return TypedPublisher.fromString(this.payloadAsStream);
            }
            return TypedMono.just(this.payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStream() {
        StringContent stringContent = this;
        synchronized (stringContent) {
            return !this.consumed;
        }
    }

    @Override
    public void consume() {
        this.consumeIfNeeded();
    }

    public String toString() {
        if (this.consumed) {
            return "String{type=" + this.type.getName() + ", mimeType=" + this.mimeType + ", consumed=" + this.consumed + ", streamReleased=" + this.streamReleased + ", data='" + this.payload + '\'' + '}';
        }
        return "String{type=" + this.type.getName() + ", mimeType=" + this.mimeType + ", consumed=" + this.consumed + ", streamReleased=" + this.streamReleased + ", data='" + this.payloadAsStream + '\'' + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeIfNeeded() {
        if (!this.consumed) {
            StringContent stringContent = this;
            synchronized (stringContent) {
                if (!this.consumed) {
                    if (this.streamReleased) {
                        throw new PlatformException("Stream has been already released. This payload cannot be consumed anymore.");
                    }
                    this.payload = StreamUtils.FromString.consume(this.payloadAsStream);
                    this.consumed = true;
                }
            }
        }
    }
}

