/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.message.content;

import de.codecentric.reedelk.runtime.api.commons.Preconditions;
import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.message.content.TypedContent;
import de.codecentric.reedelk.runtime.api.message.content.TypedMono;
import de.codecentric.reedelk.runtime.api.message.content.TypedPublisher;
import reactor.core.publisher.Mono;

public class ObjectContent<ItemType>
implements TypedContent<ItemType, ItemType> {
    private final MimeType mimeType = MimeType.APPLICATION_JAVA;
    private final transient Mono<ItemType> dataAsStream;
    private final Class<ItemType> type;
    private ItemType data;
    private boolean consumed;
    private boolean streamReleased = false;

    public ObjectContent(ItemType data) {
        Preconditions.checkNotNull(data, "Cannot create object content with null data; use empty content instead");
        this.checkIsAcceptedTypeOrThrow(data.getClass());
        this.data = data;
        this.type = data.getClass();
        this.dataAsStream = null;
        this.consumed = true;
    }

    public ObjectContent(Mono<ItemType> monoStream, Class<ItemType> type) {
        Preconditions.checkNotNull(monoStream, "Cannot create object content with null data; use empty content instead");
        this.checkIsAcceptedTypeOrThrow(type);
        this.type = type;
        this.dataAsStream = monoStream;
        this.consumed = false;
    }

    @Override
    public Class<ItemType> type() {
        return this.type;
    }

    @Override
    public Class<ItemType> streamType() {
        return this.type;
    }

    @Override
    public MimeType mimeType() {
        return this.mimeType;
    }

    @Override
    public ItemType data() {
        this.consumeIfNeeded();
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedPublisher<ItemType> stream() {
        if (this.consumed) {
            return TypedMono.just(this.data, this.type);
        }
        ObjectContent objectContent = this;
        synchronized (objectContent) {
            if (!this.consumed) {
                if (this.streamReleased) {
                    throw new PlatformException("Stream has been already released. This data cannot be consumed anymore.");
                }
                this.streamReleased = true;
                return TypedMono.from(this.dataAsStream, this.type);
            }
            return TypedMono.just(this.data, this.type);
        }
    }

    @Override
    public boolean isStream() {
        return false;
    }

    @Override
    public void consume() {
        this.consumeIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeIfNeeded() {
        if (!this.consumed) {
            ObjectContent objectContent = this;
            synchronized (objectContent) {
                if (!this.consumed) {
                    if (this.streamReleased) {
                        throw new PlatformException("Stream has been already released. This data cannot be consumed anymore.");
                    }
                    this.data = this.dataAsStream.block();
                    this.consumed = true;
                }
            }
        }
    }

    public String toString() {
        if (this.consumed) {
            return "ObjectContent{type=" + this.type.getName() + ", mimeType=" + this.mimeType + ", consumed=" + this.consumed + ", streamReleased=" + this.streamReleased + ", data=" + this.data + '}';
        }
        return "ObjectContent{type=" + this.type.getName() + ", mimeType=" + this.mimeType + ", consumed=" + this.consumed + ", streamReleased=" + this.streamReleased + ", data=" + this.dataAsStream + '}';
    }

    private void checkIsAcceptedTypeOrThrow(Class<?> dataTypeClass) {
        Preconditions.checkState(!String.class.equals(dataTypeClass), "Cannot create object content with String type; use MessageBuilder.withString(..) or create a new StringContent type.");
        Preconditions.checkState(!Byte.class.equals(dataTypeClass), "Cannot create object content with byte array type; use MessageBuilder.withBinary(..) or create a new ByteArrayContent type.");
        Preconditions.checkState(!Byte.TYPE.equals(dataTypeClass), "Cannot create object content with byte array type; use MessageBuilder.withBinary(..) or create a new ByteArrayContent type.");
    }
}

