/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.message.content;

import de.codecentric.reedelk.runtime.api.annotation.Type;
import de.codecentric.reedelk.runtime.api.annotation.TypeFunction;
import de.codecentric.reedelk.runtime.api.commons.StringUtils;
import de.codecentric.reedelk.runtime.api.message.content.Pair;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;

@Type(description="A mime type encapsulates information about the mime type of the content. A mime type is composed by a primary type (e.g image) and by a sub type (e.g jpeg).")
public class MimeType
implements Serializable {
    private static final String CHARSET_PARAM = "charset";
    private final String subType;
    private final String charset;
    private final String primaryType;
    private final Map<String, String> params;
    private final List<String> fileExtensions;
    private final Class<?> javaType;
    public static final MimeType TEXT_CSS = MimeType.of("text", "css", Collections.singletonList("css"), String.class);
    public static final MimeType TEXT_CSV = MimeType.of("text", "csv", Collections.singletonList("csv"), String.class);
    public static final MimeType TEXT_HTML = MimeType.of("text", "html", Arrays.asList("html", "htm", "stm"), String.class);
    public static final MimeType TEXT_PLAIN = MimeType.of("text", "plain", Arrays.asList("txt", "bas", "c", "h", "java"), String.class);
    public static final MimeType TEXT_RICH = MimeType.of("text", "richtext", Collections.singletonList("rtx"), String.class);
    public static final MimeType TEXT_SCRIPTLET = MimeType.of("text", "scriptlet", Collections.singletonList("sct"), String.class);
    public static final MimeType TEXT_TAB_SEPARATED_VALUES = MimeType.of("text", "tab-separated-values", Collections.singletonList("tsv"), String.class);
    public static final MimeType TEXT_HYPERTEXT_TEMPLATE_FILE = MimeType.of("text", "webviewhtml", Collections.singletonList("htt"), String.class);
    public static final MimeType TEXT_HTML_COMPONENT_FILE = MimeType.of("text", "x-component", Collections.singletonList("htc"), String.class);
    public static final MimeType TEXT_TEX_FONT_ENCLOSING_FILE = MimeType.of("text", "x-setext", Collections.singletonList("etx"), String.class);
    public static final MimeType TEXT_VCARD_FILE = MimeType.of("text", "x-vcard", Collections.singletonList("vcf"), String.class);
    public static final MimeType TEXT_XML = MimeType.of("text", "xml", Collections.singletonList("xml"), String.class);
    public static final MimeType TEXT_JSON = MimeType.of("text", "json", Collections.singletonList("json"), String.class);
    public static final MimeType TEXT_JAVASCRIPT = MimeType.of("text", "javascript", Collections.singletonList("js"), String.class);
    public static final MimeType IMAGE_BITMAP = MimeType.of("image", "bmp", Collections.singletonList("bmp"), byte[].class);
    public static final MimeType IMAGE_GIF = MimeType.of("image", "gif", Collections.singletonList("gif"), byte[].class);
    public static final MimeType IMAGE_PNG = MimeType.of("image", "png", Collections.singletonList("png"), byte[].class);
    public static final MimeType IMAGE_JPEG = MimeType.of("image", "jpeg", Arrays.asList("jpeg", "jpe", "jpg"), byte[].class);
    public static final MimeType IMAGE_JPEG_INTERCHANGE = MimeType.of("image", "pipeg", Collections.singletonList("jfif"), byte[].class);
    public static final MimeType IMAGE_SVG = MimeType.of("image", "svg+xml", Collections.singletonList("svg"), String.class);
    public static final MimeType IMAGE_TIFF = MimeType.of("image", "tiff", Arrays.asList("tiff", "tif"), byte[].class);
    public static final MimeType IMAGE_SUN_RASTER_GRAPHIC = MimeType.of("image", "x-cmu-raster", Collections.singletonList("ras"), byte[].class);
    public static final MimeType IMAGE_COREL_METAFILE_EXCHANGE_FILE = MimeType.of("image", "x-cmx", Collections.singletonList("cmx"), byte[].class);
    public static final MimeType IMAGE_ICON = MimeType.of("image", "x-icon", Collections.singletonList("ico"), byte[].class);
    public static final MimeType IMAGE_PORTABLE_ANY_MAP_IMAGE = MimeType.of("image", "x-portable-anymap", Collections.singletonList("pnm"), byte[].class);
    public static final MimeType IMAGE_PORTABLE_BITMAP_IMAGE = MimeType.of("image", "x-portable-bitmap", Collections.singletonList("pbm"), byte[].class);
    public static final MimeType IMAGE_PORTABLE_GRAYMAP_IMAGE = MimeType.of("image", "x-portable-graymap", Collections.singletonList("pgm"), byte[].class);
    public static final MimeType IMAGE_PORTABLE_PIXMAP_IMAGE = MimeType.of("image", "x-portable-pixmap", Collections.singletonList("ppm"), byte[].class);
    public static final MimeType IMAGE_RGB_BITMAP = MimeType.of("image", "x-rgb", Collections.singletonList("rgb"), byte[].class);
    public static final MimeType IMAGE_X11_BITMAP = MimeType.of("image", "x-xbitmap", Collections.singletonList("xbm"), byte[].class);
    public static final MimeType IMAGE_X11_PIXMAP = MimeType.of("image", "x-xpixmap", Collections.singletonList("xpm"), byte[].class);
    public static final MimeType IMAGE_X_WINDOWS_DUMP = MimeType.of("image", "x-xwindowdump", Collections.singletonList("xwd"), byte[].class);
    public static final MimeType IMAGE_FILE = MimeType.of("image", "ief", Collections.singletonList("ief"), byte[].class);
    public static final MimeType MESSAGE_RFC822 = MimeType.of("message", "rfc822", Arrays.asList("mht", "mhtml", "nws"));
    public static final MimeType VIDEO_MPEG = MimeType.of("video", "mpeg", Arrays.asList("mp2", "mpa", "mpe", "mpeg", "mpg", "mpv2"), byte[].class);
    public static final MimeType VIDEO_MPEG4 = MimeType.of("video", "mp4", Collections.singletonList("mp4"), byte[].class);
    public static final MimeType VIDEO_QUICKTIME = MimeType.of("video", "quicktime", Arrays.asList("mov", "qt"), byte[].class);
    public static final MimeType VIDEO_LOGOS_LIBRARY_FILE = MimeType.of("video", "x-la-asf", Arrays.asList("lsf", "lsx"), byte[].class);
    public static final MimeType VIDEO_MICROSOFT_ASF = MimeType.of("video", "x-ms-asf", Arrays.asList("asf", "asr", "asx"), byte[].class);
    public static final MimeType VIDEO_AVI_FILE = MimeType.of("video", "x-msvideo", Collections.singletonList("avi"), byte[].class);
    public static final MimeType VIDEO_QUICKTIME_MOVIE = MimeType.of("video", "x-sgi-movie", Collections.singletonList("movie"), byte[].class);
    public static final MimeType AUDIO_BASIC = MimeType.of("audio", "basic", Arrays.asList("au", "snd"), byte[].class);
    public static final MimeType AUDIO_MIDI = MimeType.of("audio", "mid", Arrays.asList("mid", "rmi"), byte[].class);
    public static final MimeType AUDIO_MP3 = MimeType.of("audio", "mpeg", Collections.singletonList("mp3"), byte[].class);
    public static final MimeType AUDIO_INTERCHANGE_FORMAT = MimeType.of("audio", "x-aiff", Arrays.asList("aif", "aifc", "aiff"), byte[].class);
    public static final MimeType AUDIO_MEDIA_PLAYLIST_FILE = MimeType.of("audio", "x-mpegurl", Collections.singletonList("m3u"), byte[].class);
    public static final MimeType AUDIO_REAL_AUDIO_FILE = MimeType.of("audio", "x-pn-realaudio", Arrays.asList("ra", "ram"), byte[].class);
    public static final MimeType AUDIO_WAVE = MimeType.of("audio", "x-wav", Collections.singletonList("wav"), byte[].class);
    public static final MimeType APPLICATION_COREL_ENVOY = MimeType.of("application", "envoy", Collections.singletonList("evy"));
    public static final MimeType APPLICATION_FRACTAL_IMAGE_FILE = MimeType.of("application", "fractals", Collections.singletonList("fif"));
    public static final MimeType APPLICATION_WINDOWS_PRINT_SPOOL_FILE = MimeType.of("application", "futuresplash", Collections.singletonList("spl"));
    public static final MimeType APPLICATION_HTA = MimeType.of("application", "hta", Collections.singletonList("hta"));
    public static final MimeType APPLICATION_WORD = MimeType.of("application", "msword", Arrays.asList("doc", "dot"));
    public static final MimeType APPLICATION_BINARY = MimeType.of("application", "octet-stream", Arrays.asList("*", "bin", "class", "dms", "exe", "jar", "lha", "lzh"), byte[].class);
    public static final MimeType APPLICATION_CALS_RASTER_IMAGE = MimeType.of("application", "oda", Collections.singletonList("oda"));
    public static final MimeType APPLICATION_ACTIVEX_SCRIPT = MimeType.of("application", "olescript", Collections.singletonList("axs"));
    public static final MimeType APPLICATION_ACROBAT_FILE = MimeType.of("application", "pdf", Collections.singletonList("pdf"));
    public static final MimeType APPLICATION_OUTLOOK_PROFILE_FILE = MimeType.of("application", "pics-rules", Collections.singletonList("prf"));
    public static final MimeType APPLICATION_CERTIFICATE_REQUEST_FILE = MimeType.of("application", "pkcs10", Collections.singletonList("p10"));
    public static final MimeType APPLICATION_CERTIFICATE_REVOCATION_LIST_FILE = MimeType.of("application", "pkix-crl", Collections.singletonList("crl"));
    public static final MimeType APPLICATION_ADOBE_ILLUSTRATOR_LIST_FILE = MimeType.of("application", "postscript", Arrays.asList("ai", "eps", "ps"));
    public static final MimeType APPLICATION_RICH_TEXT = MimeType.of("application", "rtf", Collections.singletonList("rtf"));
    public static final MimeType APPLICATION_SET_PAYMENT_INITIATION = MimeType.of("application", "set-payment-initiation", Collections.singletonList("setpay"));
    public static final MimeType APPLICATION_SET_REGISTRATION_INITIATION = MimeType.of("application", "set-registration-initiation", Collections.singletonList("setreg"));
    public static final MimeType APPLICATION_EXCEL = MimeType.of("application", "vnd.ms-excel", Arrays.asList("xla", "xlc", "xlm", "xls", "xlt", "xlw"));
    public static final MimeType APPLICATION_OUTLOOK = MimeType.of("application", "vnd.ms-outlook", Collections.singletonList("msg"));
    public static final MimeType APPLICATION_CERTIFICATE_STORE_FILE = MimeType.of("application", "vnd.ms-pkicertstore", Collections.singletonList("sst"));
    public static final MimeType APPLICATION_WINDOWS_CATALOG_FILE = MimeType.of("application", "vnd.ms-pkiseccat", Collections.singletonList("cat"));
    public static final MimeType APPLICATION_WINDOWS_STEREOLITHOGRAPHY_FILE = MimeType.of("application", "vnd.ms-pkistl", Collections.singletonList("stl"));
    public static final MimeType APPLICATION_POWERPOINT = MimeType.of("application", "vnd.ms-powerpoint", Arrays.asList("pot", "pps", "ppt"));
    public static final MimeType APPLICATION_MICROSOFT_PROJECT = MimeType.of("application", "vnd.ms-project", Collections.singletonList("mpp"));
    public static final MimeType APPLICATION_MICROSOFT_WORKS = MimeType.of("application", "vnd.ms-works", Arrays.asList("wcm", "wdb", "wks", "wps"));
    public static final MimeType APPLICATION_WINDOWS_HELP = MimeType.of("application", "winhlp", Collections.singletonList("hlp"));
    public static final MimeType APPLICATION_BINARY_CPIO = MimeType.of("application", "x-bcpio", Collections.singletonList("bcpio"));
    public static final MimeType APPLICATION_COMPUTABLE_DOCUMENT_FORMAT_FILE = MimeType.of("application", "x-cdf", Collections.singletonList("cdf"));
    public static final MimeType APPLICATION_UNIX_COMPRESSED_FILE = MimeType.of("application", "x-compress", Collections.singletonList("z"));
    public static final MimeType APPLICATION_GZIPPED_TAR_FILE = MimeType.of("application", "x-compressed", Collections.singletonList("tgz"));
    public static final MimeType APPLICATION_UNIX_CPIO_ARCHIVE = MimeType.of("application", "x-cpio", Collections.singletonList("cpio"));
    public static final MimeType APPLICATION_PHOTOSHOP_CUSTOM_SHAPE = MimeType.of("application", "x-csh", Collections.singletonList("csh"));
    public static final MimeType APPLICATION_DIRECTOR_FILE = MimeType.of("application", "x-director", Arrays.asList("dcr", "dir", "dxr"));
    public static final MimeType APPLICATION_DEVICE_INDIPENDENT_FORMAT_FILE = MimeType.of("application", "x-dvi", Collections.singletonList("dvi"));
    public static final MimeType APPLICATION_GNU_TAR_ARCHIVE = MimeType.of("application", "x-gtar", Collections.singletonList("gtar"));
    public static final MimeType APPLICATION_GNU_ZIPPED_ARCHIVE = MimeType.of("application", "x-gzip", Collections.singletonList("gz"));
    public static final MimeType APPLICATION_HIERARCHICAL_DATA_FORMAT = MimeType.of("application", "x-hdf", Collections.singletonList("hdf"));
    public static final MimeType APPLICATION_INTERNET_SETTINGS_FILE = MimeType.of("application", "x-internet-signup", Arrays.asList("ins", "isp"));
    public static final MimeType APPLICATION_JAVASCRIPT = MimeType.of("application", "javascript", Collections.singletonList("js"), String.class);
    public static final MimeType APPLICATION_LATEX_FILE = MimeType.of("application", "x-latex", Collections.singletonList("latex"), String.class);
    public static final MimeType APPLICATION_MICROSOFT_ACCESS_DATABASE = MimeType.of("application", "x-msaccess", Collections.singletonList("mdb"));
    public static final MimeType APPLICATION_WINDOWS_CARDSPACE_FILE = MimeType.of("application", "x-mscardfile", Collections.singletonList("crd"));
    public static final MimeType APPLICATION_CRAZY_TALK_CLIP_FILE = MimeType.of("application", "x-msclip", Collections.singletonList("clp"));
    public static final MimeType APPLICATION_DYNAMIC_LINK_LIBRARY = MimeType.of("application", "x-msdownload", Collections.singletonList("dll"));
    public static final MimeType APPLICATION_MICROSOFT_MEDIA_VIEWER_FILE = MimeType.of("application", "x-msmediaview", Arrays.asList("m13", "m14", "mvb"));
    public static final MimeType APPLICATION_WINDOWS_META_FILE = MimeType.of("application", "x-msmetafile", Collections.singletonList("wmf"));
    public static final MimeType APPLICATION_MICROSOFT_MONEY_FILE = MimeType.of("application", "x-msmoney", Collections.singletonList("mny"));
    public static final MimeType APPLICATION_MICROSOFT_PUBLISHER_FILE = MimeType.of("application", "x-mspublisher", Collections.singletonList("pub"));
    public static final MimeType APPLICATION_TURBO_TAX_SCHEDULER_LIST = MimeType.of("application", "x-msschedule", Collections.singletonList("scd"));
    public static final MimeType APPLICATION_FTR_MEDIA_FILE = MimeType.of("application", "x-msterminal", Collections.singletonList("trm"));
    public static final MimeType APPLICATION_MICROSOFT_WRITE_FILE = MimeType.of("application", "x-mswrite", Collections.singletonList("wri"));
    public static final MimeType APPLICATION_NET_COMPUTABLE_DOCUMENT_FORMAT_FILE = MimeType.of("application", "x-netcdf", Arrays.asList("cdf", "nc"));
    public static final MimeType APPLICATION_PKCS12_FILE = MimeType.of("application", "x-pkcs12", Arrays.asList("p12", "pfx"));
    public static final MimeType APPLICATION_PKCS7_FILE = MimeType.of("application", "x-pkcs7-certificates", Arrays.asList("p7b", "spc"));
    public static final MimeType APPLICATION_PKCS7_RESPONSE_FILE = MimeType.of("application", "x-pkcs7-certreqresp", Collections.singletonList("p7r"));
    public static final MimeType APPLICATION_PKCS7_MIME = MimeType.of("application", "x-pkcs7-mime", Arrays.asList("p7c", "p7m"));
    public static final MimeType APPLICATION_PKCS7_SIGNATURE = MimeType.of("application", "x-pkcs7-signature", Collections.singletonList("p7s"));
    public static final MimeType APPLICATION_BASH_SHELL_SCRIPT = MimeType.of("application", "x-sh", Collections.singletonList("sh"));
    public static final MimeType APPLICATION_UNIX_SHAR_ARCHIVE = MimeType.of("application", "x-shar", Collections.singletonList("shar"));
    public static final MimeType APPLICATION_FLASH_FILE = MimeType.of("application", "x-shockwave-flash", Collections.singletonList("swf"));
    public static final MimeType APPLICATION_X_TAR = MimeType.of("application", "x-tar", Collections.singletonList("tar"));
    public static final MimeType APPLICATION_X_509 = MimeType.of("application", "x-x509-ca-cert", Arrays.asList("cer", "crt", "der"));
    public static final MimeType APPLICATION_ZIP = MimeType.of("application", "zip", Collections.singletonList("zip"));
    public static final MimeType APPLICATION_ATOM = MimeType.of("application", "atom+xml", Collections.singletonList("atom"), String.class);
    public static final MimeType APPLICATION_RSS = MimeType.of("application", "rss+xml", Collections.singletonList("rss"), String.class);
    public static final MimeType APPLICATION_XML = MimeType.of("application", "xml", Collections.singletonList("xml"), String.class);
    public static final MimeType APPLICATION_JSON = MimeType.of("application", "json", Collections.singletonList("json"), String.class);
    public static final MimeType APPLICATION_JAVA = MimeType.of("application", "java");
    public static final MimeType APPLICATION_FORM_URL_ENCODED = MimeType.of("application", "x-www-form-urlencoded", String.class);
    public static final MimeType ANY = MimeType.of("*", "*");
    public static final MimeType UNKNOWN = MimeType.of("content", "unknown");
    public static final MimeType MULTIPART_FORM_DATA = MimeType.of("multipart", "form-data", Map.class);
    public static final List<MimeType> ALL = Arrays.asList(TEXT_CSS, TEXT_HTML, TEXT_PLAIN, TEXT_RICH, TEXT_SCRIPTLET, TEXT_TAB_SEPARATED_VALUES, TEXT_CSV, TEXT_HYPERTEXT_TEMPLATE_FILE, TEXT_HTML_COMPONENT_FILE, TEXT_TEX_FONT_ENCLOSING_FILE, TEXT_VCARD_FILE, TEXT_XML, TEXT_JSON, TEXT_JAVASCRIPT, IMAGE_BITMAP, IMAGE_GIF, IMAGE_PNG, IMAGE_JPEG, IMAGE_JPEG_INTERCHANGE, IMAGE_SVG, IMAGE_TIFF, IMAGE_SUN_RASTER_GRAPHIC, IMAGE_COREL_METAFILE_EXCHANGE_FILE, IMAGE_ICON, IMAGE_PORTABLE_ANY_MAP_IMAGE, IMAGE_PORTABLE_BITMAP_IMAGE, IMAGE_PORTABLE_GRAYMAP_IMAGE, IMAGE_PORTABLE_PIXMAP_IMAGE, IMAGE_RGB_BITMAP, IMAGE_X11_BITMAP, IMAGE_X11_PIXMAP, IMAGE_X_WINDOWS_DUMP, IMAGE_FILE, MESSAGE_RFC822, VIDEO_MPEG, VIDEO_MPEG4, VIDEO_QUICKTIME, VIDEO_LOGOS_LIBRARY_FILE, VIDEO_MICROSOFT_ASF, VIDEO_AVI_FILE, VIDEO_QUICKTIME_MOVIE, AUDIO_BASIC, AUDIO_MIDI, AUDIO_MP3, AUDIO_INTERCHANGE_FORMAT, AUDIO_MEDIA_PLAYLIST_FILE, AUDIO_REAL_AUDIO_FILE, AUDIO_WAVE, APPLICATION_COREL_ENVOY, APPLICATION_FRACTAL_IMAGE_FILE, APPLICATION_WINDOWS_PRINT_SPOOL_FILE, APPLICATION_HTA, APPLICATION_WORD, APPLICATION_BINARY, APPLICATION_CALS_RASTER_IMAGE, APPLICATION_ACTIVEX_SCRIPT, APPLICATION_ACROBAT_FILE, APPLICATION_OUTLOOK_PROFILE_FILE, APPLICATION_CERTIFICATE_REQUEST_FILE, APPLICATION_CERTIFICATE_REVOCATION_LIST_FILE, APPLICATION_ADOBE_ILLUSTRATOR_LIST_FILE, APPLICATION_RICH_TEXT, APPLICATION_SET_PAYMENT_INITIATION, APPLICATION_SET_REGISTRATION_INITIATION, APPLICATION_EXCEL, APPLICATION_OUTLOOK, APPLICATION_CERTIFICATE_STORE_FILE, APPLICATION_WINDOWS_CATALOG_FILE, APPLICATION_WINDOWS_STEREOLITHOGRAPHY_FILE, APPLICATION_POWERPOINT, APPLICATION_MICROSOFT_PROJECT, APPLICATION_MICROSOFT_WORKS, APPLICATION_WINDOWS_HELP, APPLICATION_BINARY_CPIO, APPLICATION_COMPUTABLE_DOCUMENT_FORMAT_FILE, APPLICATION_UNIX_COMPRESSED_FILE, APPLICATION_GZIPPED_TAR_FILE, APPLICATION_UNIX_CPIO_ARCHIVE, APPLICATION_PHOTOSHOP_CUSTOM_SHAPE, APPLICATION_DIRECTOR_FILE, APPLICATION_DEVICE_INDIPENDENT_FORMAT_FILE, APPLICATION_GNU_TAR_ARCHIVE, APPLICATION_GNU_ZIPPED_ARCHIVE, APPLICATION_HIERARCHICAL_DATA_FORMAT, APPLICATION_INTERNET_SETTINGS_FILE, APPLICATION_JAVASCRIPT, APPLICATION_LATEX_FILE, APPLICATION_MICROSOFT_ACCESS_DATABASE, APPLICATION_WINDOWS_CARDSPACE_FILE, APPLICATION_CRAZY_TALK_CLIP_FILE, APPLICATION_DYNAMIC_LINK_LIBRARY, APPLICATION_MICROSOFT_MEDIA_VIEWER_FILE, APPLICATION_WINDOWS_META_FILE, APPLICATION_MICROSOFT_MONEY_FILE, APPLICATION_MICROSOFT_PUBLISHER_FILE, APPLICATION_TURBO_TAX_SCHEDULER_LIST, APPLICATION_FTR_MEDIA_FILE, APPLICATION_MICROSOFT_WRITE_FILE, APPLICATION_NET_COMPUTABLE_DOCUMENT_FORMAT_FILE, APPLICATION_PKCS12_FILE, APPLICATION_PKCS7_FILE, APPLICATION_PKCS7_RESPONSE_FILE, APPLICATION_PKCS7_MIME, APPLICATION_PKCS7_SIGNATURE, APPLICATION_BASH_SHELL_SCRIPT, APPLICATION_UNIX_SHAR_ARCHIVE, APPLICATION_FLASH_FILE, APPLICATION_X_TAR, APPLICATION_X_509, APPLICATION_ZIP, APPLICATION_ATOM, APPLICATION_RSS, APPLICATION_XML, APPLICATION_JSON, APPLICATION_JAVA, APPLICATION_FORM_URL_ENCODED, ANY, UNKNOWN, MULTIPART_FORM_DATA);
    public static final String MIME_TYPE_PROTOTYPE = "XXXXXXXXXXXXXXXXXXXXXXXXXX";
    private static final Map<String, MimeType> EXTENSION_MIME_TYPE_MAP;
    public static final Map<PrimaryAndSubtypeKey, MimeType> MIME_TYPE_JAVA;

    public static MimeType fromFileExtension(String extension, MimeType defaultMime) {
        if (StringUtils.isBlank(extension)) {
            return defaultMime;
        }
        if (EXTENSION_MIME_TYPE_MAP.containsKey(extension)) {
            return EXTENSION_MIME_TYPE_MAP.get(extension);
        }
        return defaultMime;
    }

    public static MimeType of(String primaryType, String subType, Class<?> javaType) {
        return new MimeType(primaryType, subType, null, javaType, null, null);
    }

    public static MimeType of(String primaryType, String subType) {
        return new MimeType(primaryType, subType, null, null, null, null);
    }

    public static MimeType of(String primaryType, String subType, List<String> fileExtensions) {
        return new MimeType(primaryType, subType, null, null, null, fileExtensions);
    }

    public static MimeType of(String primaryType, String subType, List<String> fileExtensions, Class<?> javaType) {
        return new MimeType(primaryType, subType, null, javaType, null, fileExtensions);
    }

    public static MimeType of(String primaryType, String subType, Map<String, String> params, Class<?> javaType) {
        return new MimeType(primaryType, subType, null, javaType, params, null);
    }

    public static MimeType of(String primaryType, String subType, Map<String, String> params, List<String> fileExtensions, Class<?> javaType) {
        return new MimeType(primaryType, subType, null, javaType, params, fileExtensions);
    }

    public static MimeType of(String primaryType, String subType, Map<String, String> params, List<String> fileExtensions, Class<?> javaType, String charset) {
        return new MimeType(primaryType, subType, charset, javaType, params, fileExtensions);
    }

    public static MimeType parse(String mimeType) {
        return MimeType.parse(mimeType, UNKNOWN);
    }

    public static MimeType parse(String mimeType, MimeType defaultMimeType) {
        if (mimeType == null) {
            return defaultMimeType;
        }
        try {
            return MimeType.internalParse(mimeType);
        }
        catch (Exception e) {
            return defaultMimeType;
        }
    }

    public MimeType(String primaryType, String subType, String charset, Class<?> javaType, Map<String, String> params, List<String> fileExtensions) {
        this.subType = subType;
        this.charset = charset;
        this.javaType = javaType == null ? Object.class : javaType;
        this.primaryType = primaryType;
        this.params = params != null ? Collections.unmodifiableMap(params) : Collections.emptyMap();
        this.fileExtensions = fileExtensions != null ? Collections.unmodifiableList(fileExtensions) : Collections.emptyList();
    }

    @TypeFunction(signature="subType()", example="message.content().mimeType().subType()", description="Returns the sub-type of the mime type.")
    public String subType() {
        return this.subType;
    }

    public String getSubType() {
        return this.subType;
    }

    public Optional<Charset> getCharset() {
        return Optional.ofNullable(this.getCharset(this.charset, this.params));
    }

    @TypeFunction(signature="primaryType()", example="message.content().mimeType().primaryType()", description="Returns the primary type of the mime type.")
    public String primaryType() {
        return this.primaryType;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    @TypeFunction(signature="fileExtensions()", example="message.content().mimeType().fileExtensions()", description="Returns a list of file extensions associated to this mime type.")
    public List<String> fileExtensions() {
        return this.fileExtensions;
    }

    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public Class<?> javaType() {
        return this.javaType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MimeType mimeType = (MimeType)o;
        return Objects.equals(this.subType, mimeType.subType) && Objects.equals(this.primaryType, mimeType.primaryType);
    }

    public int hashCode() {
        return Objects.hash(this.subType, this.primaryType);
    }

    private static MimeType internalParse(String mimeType) {
        String[] parts = mimeType.split(";");
        HashMap<String, String> params = new HashMap<String, String>();
        String charset = null;
        for (int i = 1; i < parts.length; ++i) {
            String p = parts[i];
            String[] subParts = p.split("=");
            if (subParts.length != 2) continue;
            String paramKey = subParts[0].trim();
            String paramValue = subParts[1].trim();
            if (CHARSET_PARAM.equals(paramKey)) {
                charset = paramValue;
                continue;
            }
            params.put(subParts[0].trim(), subParts[1].trim());
        }
        String fullType = parts[0].trim();
        if (fullType.equals("*")) {
            fullType = "*/*";
        }
        String[] types = fullType.split("/");
        String primaryType = MimeType.toLowercase(types[0].trim());
        String subType = MimeType.toLowercase(types[1].trim());
        MimeType matching = MIME_TYPE_JAVA.get(PrimaryAndSubtypeKey.from(primaryType, subType));
        Class<?> aClass = matching.getJavaType();
        List<String> fileExtensions = matching.getFileExtensions();
        return MimeType.of(primaryType, subType, params, fileExtensions, aClass, charset);
    }

    private static String toLowercase(String value) {
        return value == null ? value : value.toLowerCase();
    }

    private Charset getCharset(String given, Map<String, String> params) {
        if (given != null) {
            return Charset.forName(given);
        }
        return params.containsKey(CHARSET_PARAM) ? Charset.forName(params.get(CHARSET_PARAM)) : null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.params.forEach((k, v) -> buffer.append("; ").append((String)k).append("=").append((String)v));
        return this.primaryType + "/" + this.subType + (this.getCharset().isPresent() ? "; charset=" + this.getCharset().get().name() : "") + (!this.params.isEmpty() ? buffer.toString() : "");
    }

    static {
        AbstractMap tmp = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        ALL.forEach(mimeType -> mimeType.getFileExtensions().forEach(fileExtension -> tmp.put(fileExtension, mimeType)));
        EXTENSION_MIME_TYPE_MAP = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        ALL.forEach(mimeType -> tmp.put(PrimaryAndSubtypeKey.from(mimeType), mimeType));
        MIME_TYPE_JAVA = Collections.unmodifiableMap(tmp);
    }

    static class PrimaryAndSubtypeKey
    implements Pair<String, String> {
        private final String primaryType;
        private final String subType;

        static PrimaryAndSubtypeKey from(MimeType mimeType) {
            return new PrimaryAndSubtypeKey(mimeType.getPrimaryType(), mimeType.getSubType());
        }

        static PrimaryAndSubtypeKey from(String primaryType, String subType) {
            return new PrimaryAndSubtypeKey(primaryType, subType);
        }

        public PrimaryAndSubtypeKey(String primaryType, String subType) {
            this.primaryType = primaryType;
            this.subType = subType;
        }

        @Override
        public String getLeft() {
            return this.primaryType;
        }

        @Override
        public String getRight() {
            return this.subType;
        }

        @Override
        public String left() {
            return this.primaryType;
        }

        @Override
        public String right() {
            return this.subType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrimaryAndSubtypeKey that = (PrimaryAndSubtypeKey)o;
            return Objects.equals(this.primaryType, that.primaryType) && Objects.equals(this.subType, that.subType);
        }

        public int hashCode() {
            return Objects.hash(this.primaryType, this.subType);
        }
    }

    public static class AsString {
        public static final String ANY = "*/*";
        public static final String TEXT_PLAIN = "text/plain";
        public static final String TEXT_HTML = "text/html";
        public static final String TEXT_XML = "text/xml";
        public static final String IMAGE_JPEG = "image/jpeg";
        public static final String APPLICATION_JSON = "application/json";
        public static final String APPLICATION_JAVA = "application/java";
        public static final String APPLICATION_BINARY = "application/octet-stream";
    }
}

