/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.message.content;

import de.codecentric.reedelk.runtime.api.commons.StreamUtils;
import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.message.content.TypedContent;
import de.codecentric.reedelk.runtime.api.message.content.TypedPublisher;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ListContent<StreamType>
implements TypedContent<List, StreamType> {
    private final MimeType mimeType = MimeType.APPLICATION_JAVA;
    private final transient Publisher<StreamType> payloadAsStream;
    private final Class<StreamType> streamType;
    private List<StreamType> payload;
    private boolean consumed;
    private boolean streamReleased = false;

    public ListContent(List<StreamType> payload, Class<StreamType> streamType) {
        this.payloadAsStream = null;
        this.streamType = streamType;
        this.payload = payload;
        this.consumed = true;
    }

    public ListContent(Publisher<StreamType> payloadAsStream, Class<StreamType> streamType) {
        this.streamType = streamType;
        this.payloadAsStream = payloadAsStream;
        this.consumed = false;
    }

    @Override
    public Class<List> type() {
        return List.class;
    }

    @Override
    public Class<StreamType> streamType() {
        return this.streamType;
    }

    @Override
    public MimeType mimeType() {
        return this.mimeType;
    }

    @Override
    public List<StreamType> data() {
        this.consumeIfNeeded();
        return this.payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedPublisher<StreamType> stream() {
        if (this.consumed) {
            return TypedPublisher.from(Flux.fromStream(this.payload.stream()), this.streamType);
        }
        ListContent listContent = this;
        synchronized (listContent) {
            if (!this.consumed) {
                if (this.streamReleased) {
                    throw new PlatformException("Stream has been already released. This payload cannot be consumed anymore.");
                }
                this.streamReleased = true;
                return TypedPublisher.fromObject(this.payloadAsStream, this.streamType);
            }
            return TypedPublisher.from(Flux.fromStream(this.payload.stream()), this.streamType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStream() {
        ListContent listContent = this;
        synchronized (listContent) {
            return !this.consumed;
        }
    }

    @Override
    public void consume() {
        this.consumeIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeIfNeeded() {
        if (!this.consumed) {
            ListContent listContent = this;
            synchronized (listContent) {
                if (!this.consumed) {
                    if (this.streamReleased) {
                        throw new PlatformException("Stream has been already released. This payload cannot be consumed anymore.");
                    }
                    this.payload = StreamUtils.FromObject.consume(this.payloadAsStream);
                    this.consumed = true;
                }
            }
        }
    }

    public String toString() {
        if (this.consumed) {
            return "ListContent{type=" + this.streamType.getName() + ", mimeType=" + this.mimeType + ", consumed=" + this.consumed + ", streamReleased=" + this.streamReleased + ", data=" + this.payload + '}';
        }
        return "ListContent{type=" + this.streamType.getName() + ", mimeType=" + this.mimeType + ", consumed=" + this.consumed + ", streamReleased=" + this.streamReleased + ", data=" + this.payloadAsStream + '}';
    }
}

