/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.message.content;

import de.codecentric.reedelk.runtime.api.commons.StreamUtils;
import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.message.content.TypedContent;
import de.codecentric.reedelk.runtime.api.message.content.TypedMono;
import de.codecentric.reedelk.runtime.api.message.content.TypedPublisher;
import java.util.Arrays;
import org.reactivestreams.Publisher;

public class ByteArrayContent
implements TypedContent<byte[], byte[]> {
    private final transient Publisher<byte[]> dataAsStream;
    private final Class<byte[]> type = byte[].class;
    private final MimeType mimeType;
    private boolean streamReleased = false;
    private boolean consumed;
    private byte[] data;

    public ByteArrayContent(byte[] data, MimeType mimeType) {
        this.dataAsStream = null;
        this.mimeType = mimeType;
        this.consumed = true;
        this.data = data;
    }

    public ByteArrayContent(Byte[] data, MimeType mimeType) {
        this.dataAsStream = null;
        this.mimeType = mimeType;
        this.consumed = true;
        this.data = ByteArrayContent.toPrimitives(data);
    }

    public ByteArrayContent(Publisher<byte[]> dataAsStream, MimeType mimeType) {
        this.dataAsStream = dataAsStream;
        this.mimeType = mimeType;
        this.consumed = false;
    }

    @Override
    public Class<byte[]> type() {
        return this.type;
    }

    @Override
    public Class<byte[]> streamType() {
        return this.type;
    }

    @Override
    public MimeType mimeType() {
        return this.mimeType;
    }

    @Override
    public byte[] data() {
        this.consumeIfNeeded();
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedPublisher<byte[]> stream() {
        if (this.consumed) {
            return TypedMono.just(this.data);
        }
        ByteArrayContent byteArrayContent = this;
        synchronized (byteArrayContent) {
            if (!this.consumed) {
                if (this.streamReleased) {
                    throw new PlatformException("Stream has been already released. This payload cannot be consumed anymore.");
                }
                this.streamReleased = true;
                return TypedPublisher.fromByteArray(this.dataAsStream);
            }
            return TypedMono.just(this.data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStream() {
        ByteArrayContent byteArrayContent = this;
        synchronized (byteArrayContent) {
            return !this.consumed;
        }
    }

    @Override
    public void consume() {
        this.consumeIfNeeded();
    }

    public String toString() {
        if (this.consumed) {
            return "ByteArray{type=" + this.type.getName() + ", mimeType=" + this.mimeType + ", consumed=" + this.consumed + ", streamReleased=" + this.streamReleased + ", data=" + this.toPrintableString(this.data) + '}';
        }
        return "ByteArray{type=" + this.type.getName() + ", mimeType=" + this.mimeType + ", consumed=" + this.consumed + ", streamReleased=" + this.streamReleased + ", data='" + this.dataAsStream + '\'' + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeIfNeeded() {
        if (!this.consumed) {
            ByteArrayContent byteArrayContent = this;
            synchronized (byteArrayContent) {
                if (!this.consumed) {
                    if (this.streamReleased) {
                        throw new PlatformException("Stream has been already released. This payload cannot be consumed anymore.");
                    }
                    this.data = StreamUtils.FromByteArray.consume(this.dataAsStream);
                    this.consumed = true;
                }
            }
        }
    }

    public static byte[] toPrimitives(Byte[] oBytes) {
        byte[] bytes = new byte[oBytes.length];
        for (int i = 0; i < oBytes.length; ++i) {
            bytes[i] = oBytes[i];
        }
        return bytes;
    }

    private String toPrintableString(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length < 6) {
            return Arrays.toString(data);
        }
        StringBuilder byteArrayString = new StringBuilder("[");
        for (int i = 0; i < 5; ++i) {
            byteArrayString.append(data[i]);
            byteArrayString.append(", ");
        }
        byteArrayString.append("...]");
        return byteArrayString.toString();
    }
}

