/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.message.content;

import de.codecentric.reedelk.runtime.api.annotation.Type;
import de.codecentric.reedelk.runtime.api.annotation.TypeFunction;
import de.codecentric.reedelk.runtime.api.commons.Preconditions;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Type(description="An attachment encapsulates an HTTP multipart form data object or an email attachment.")
public class Attachment
implements Serializable {
    private final String name;
    private final byte[] data;
    private final MimeType mimeType;
    private final Map<String, String> attributes = new HashMap<String, String>();

    private Attachment(String name, byte[] data, MimeType mimeType, Map<String, String> attributes) {
        Preconditions.checkNotNull(mimeType, "attachment mimeType must not be null");
        this.name = name;
        this.data = data;
        this.mimeType = mimeType;
        this.attributes.putAll(attributes);
    }

    public static Builder builder() {
        return new Builder();
    }

    @TypeFunction(signature="name()", example="attachment.name()", description="Returns the name of the attachment.")
    public String name() {
        return this.name;
    }

    @TypeFunction(signature="data()", example="attachment.data()", description="Returns the data of the attachment.")
    public byte[] data() {
        return this.data;
    }

    @TypeFunction(signature="mimeType()", example="attachment.mimeType()", description="Returns the mime type of the attachment.")
    public MimeType mimeType() {
        return this.mimeType;
    }

    @TypeFunction(signature="attributes()", example="attachment.attributes()", description="Returns the attributes of the attachment.")
    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String toString() {
        return "Attachment{name='" + this.name + '\'' + ", data=" + Arrays.toString(this.data) + ", mimeType=" + this.mimeType + ", attributes=" + this.attributes + '}';
    }

    public static boolean isAttachmentMap(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof Map)) {
            return false;
        }
        Map maybeAttachmentMap = (Map)value;
        for (Map.Entry entry : maybeAttachmentMap.entrySet()) {
            Object key = entry.getKey();
            Object entryValue = entry.getValue();
            boolean isKeyString = key instanceof String;
            boolean isValueAttachment = entryValue instanceof Attachment;
            if (isKeyString && isValueAttachment) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private String name;
        private byte[] data;
        private MimeType mimeType;
        private Map<String, String> attributes = new HashMap<String, String>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder mimeType(MimeType mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder attribute(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        public Attachment build() {
            return new Attachment(this.name, this.data, this.mimeType, this.attributes);
        }
    }
}

