/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.message;

import de.codecentric.reedelk.runtime.api.commons.Preconditions;
import de.codecentric.reedelk.runtime.api.component.Component;
import de.codecentric.reedelk.runtime.api.message.Message;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessageDefault;
import de.codecentric.reedelk.runtime.api.message.content.ByteArrayContent;
import de.codecentric.reedelk.runtime.api.message.content.EmptyContent;
import de.codecentric.reedelk.runtime.api.message.content.ListContent;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.message.content.ObjectContent;
import de.codecentric.reedelk.runtime.api.message.content.StringContent;
import de.codecentric.reedelk.runtime.api.message.content.TypedContent;
import de.codecentric.reedelk.runtime.api.message.content.TypedPublisher;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MessageBuilder {
    private TypedContent<?, ?> typedContent;
    private MessageAttributes attributes;
    private final Class<? extends Component> component;

    private MessageBuilder(Class<? extends Component> component) {
        Preconditions.checkNotNull(component, "component");
        this.component = component;
    }

    public static MessageBuilder get(Class<? extends Component> component) {
        return new MessageBuilder(component);
    }

    public MessageBuilder withXml(String xml) {
        this.typedContent = new StringContent(xml, MimeType.TEXT_XML);
        return this;
    }

    public MessageBuilder withXml(Publisher<String> xmlStream) {
        this.typedContent = new StringContent(xmlStream, MimeType.TEXT_XML);
        return this;
    }

    public MessageBuilder withHtml(String html) {
        this.typedContent = new StringContent(html, MimeType.TEXT_HTML);
        return this;
    }

    public MessageBuilder withHtml(Publisher<String> htmlStream) {
        this.typedContent = new StringContent(htmlStream, MimeType.TEXT_HTML);
        return this;
    }

    public MessageBuilder withText(String text) {
        this.typedContent = new StringContent(text, MimeType.TEXT_PLAIN);
        return this;
    }

    public MessageBuilder withText(Publisher<String> textStream) {
        this.typedContent = new StringContent(textStream, MimeType.TEXT_PLAIN);
        return this;
    }

    public MessageBuilder withJson(String json) {
        this.typedContent = new StringContent(json, MimeType.APPLICATION_JSON);
        return this;
    }

    public MessageBuilder withJson(Publisher<String> jsonStream) {
        this.typedContent = new StringContent(jsonStream, MimeType.APPLICATION_JSON);
        return this;
    }

    public MessageBuilder withString(String value, MimeType mimeType) {
        this.typedContent = new StringContent(value, mimeType);
        return this;
    }

    public MessageBuilder withString(Publisher<String> valueStream, MimeType mimeType) {
        this.typedContent = new StringContent(valueStream, mimeType);
        return this;
    }

    public MessageBuilder withBinary(byte[] bytes) {
        this.typedContent = new ByteArrayContent(bytes, MimeType.APPLICATION_BINARY);
        return this;
    }

    public MessageBuilder withBinary(byte[] bytes, MimeType mimeType) {
        this.typedContent = new ByteArrayContent(bytes, mimeType);
        return this;
    }

    public MessageBuilder withBinary(Publisher<byte[]> bytesStream) {
        this.typedContent = new ByteArrayContent(bytesStream, MimeType.APPLICATION_BINARY);
        return this;
    }

    public MessageBuilder withBinary(Publisher<byte[]> bytesStream, MimeType mimeType) {
        this.typedContent = new ByteArrayContent(bytesStream, mimeType);
        return this;
    }

    public <StreamType> MessageBuilder withTypedPublisher(TypedPublisher<StreamType> typedPublisher) {
        this.withStream(typedPublisher, typedPublisher.getType(), MimeType.APPLICATION_JAVA);
        return this;
    }

    public <StreamType> MessageBuilder withTypedPublisher(TypedPublisher<StreamType> typedPublisher, MimeType mimeType) {
        this.withStream(typedPublisher, typedPublisher.getType(), mimeType);
        return this;
    }

    private <StreamType> void withStream(TypedPublisher<StreamType> typedStream, Class<StreamType> clazz, MimeType mimeType) {
        if (String.class.equals(clazz)) {
            TypedPublisher<String> stringStream = typedStream;
            this.typedContent = new StringContent(stringStream, mimeType);
        } else if (byte[].class.equals(clazz)) {
            TypedPublisher<String> byteArrayStream = typedStream;
            this.typedContent = new ByteArrayContent(byteArrayStream, mimeType);
        } else if (Byte[].class.equals(clazz)) {
            TypedPublisher<String> byteArrayStream = typedStream;
            Flux byteArray = Flux.from(byteArrayStream).map(ByteArrayContent::toPrimitives);
            this.typedContent = new ByteArrayContent((Publisher<byte[]>)byteArray, mimeType);
        } else {
            this.typedContent = new ListContent<String>(typedStream, clazz);
        }
    }

    public MessageBuilder withJavaObject(Object object) {
        this.withJavaObject(object, MimeType.APPLICATION_JAVA);
        return this;
    }

    public <ItemType> MessageBuilder withJavaObject(Mono<ItemType> monoStream, Class<ItemType> type) {
        if (String.class.equals(type)) {
            Mono<ItemType> monoAsString = monoStream;
            this.withString((Publisher<String>)monoAsString, MimeType.TEXT_PLAIN);
        } else if (byte[].class.equals(type) || Byte[].class.equals(type)) {
            Mono<ItemType> monoAsBytes = monoStream;
            this.withBinary((Publisher<byte[]>)monoAsBytes, MimeType.APPLICATION_BINARY);
        } else {
            this.typedContent = new ObjectContent(monoStream, type);
        }
        return this;
    }

    public MessageBuilder withJavaObject(Object object, MimeType mimeType) {
        if (object == null) {
            this.typedContent = new EmptyContent();
        } else if (object instanceof Flux) {
            Flux objectStream = (Flux)object;
            this.typedContent = new ListContent<Object>((Publisher<Object>)objectStream, Object.class);
        } else if (object instanceof Mono) {
            Mono objectStream = (Mono)object;
            this.typedContent = new ObjectContent<Object>(objectStream, Object.class);
        } else if (object instanceof String) {
            this.typedContent = new StringContent((String)object, mimeType);
        } else if (object instanceof byte[]) {
            this.typedContent = new ByteArrayContent((byte[])object, mimeType);
        } else if (object instanceof Byte[]) {
            this.typedContent = new ByteArrayContent((Byte[])object, mimeType);
        } else if (object instanceof List) {
            List list = (List)object;
            this.typedContent = new ListContent<Object>(list, Object.class);
        } else {
            this.typedContent = new ObjectContent<Object>(object);
        }
        return this;
    }

    public MessageBuilder withTypedContent(TypedContent<?, ?> typedContent) {
        this.typedContent = typedContent;
        return this;
    }

    public <ItemType> MessageBuilder withList(List<ItemType> list, Class<ItemType> listItemType) {
        this.typedContent = new ListContent<ItemType>(list, listItemType);
        return this;
    }

    public MessageBuilder empty() {
        this.typedContent = new EmptyContent();
        return this;
    }

    public MessageBuilder attributes(MessageAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public Message build() {
        MessageAttributes messageAttributes = this.attributes == null ? new MessageAttributes() : this.attributes;
        messageAttributes.setComponent(this.component);
        if (this.typedContent == null) {
            throw new IllegalStateException("Typed content missing");
        }
        return new MessageDefault(this.typedContent, messageAttributes);
    }
}

