/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.message;

import de.codecentric.reedelk.runtime.api.annotation.Type;
import de.codecentric.reedelk.runtime.api.annotation.TypeFunction;
import de.codecentric.reedelk.runtime.api.message.MessageAttributes;
import de.codecentric.reedelk.runtime.api.message.MessagePayload;
import de.codecentric.reedelk.runtime.api.message.content.TypedContent;
import java.io.Serializable;

@Type(description="The Message encapsulates data and attributes passing through the components of a flow.")
public interface Message
extends Serializable {
    default public <T> T getPayload() {
        return this.payload();
    }

    @TypeFunction(returnType=MessagePayload.class, signature="payload()", example="message.payload()", description="Returns the payload (data) of the message. The payload could be a text, a byte array, a collection and so on depending on the component which generated it.")
    public <T> T payload();

    public <T, StreamType, U extends TypedContent<T, StreamType>> U getContent();

    @TypeFunction(returnType=TypedContent.class, signature="content()", example="message.content()", description="Returns the content descriptor of this message. The message content contains information about the payload's mime type, data type and stream status.")
    public <T, StreamType, U extends TypedContent<T, StreamType>> U content();

    public MessageAttributes getAttributes();

    @TypeFunction(returnType=MessageAttributes.class, signature="attributes()", example="message.attributes()", description="Returns the message attributes belonging to this message.")
    public MessageAttributes attributes();
}

