/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.exception;

import de.codecentric.reedelk.runtime.api.component.Implementor;
import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ComponentInputException
extends PlatformException {
    public ComponentInputException(Class<? extends Implementor> implementor, Object actualInputType, Class<?> ... expectedInputTypes) {
        super(ComponentInputException.formatErrorMessage(implementor, actualInputType, expectedInputTypes));
    }

    private static String formatErrorMessage(Class<? extends Implementor> implementor, Object actualInputType, Class<?> ... expectedInputTypes) {
        String actualType = ComponentInputException.topmostInterfaceOf(actualInputType);
        List expectedTypes = Arrays.stream(expectedInputTypes).map(Class::getSimpleName).collect(Collectors.toList());
        if (expectedTypes.size() > 1) {
            return String.format("%s (%s) was invoked with a not supported Input Type: actual=[%s], expected one of=[%s].", implementor.getSimpleName(), implementor.getName(), actualType, String.join((CharSequence)",", expectedTypes));
        }
        return String.format("%s (%s) was invoked with a not supported Input Type: actual=[%s], expected=[%s].", implementor.getSimpleName(), implementor.getName(), actualType, String.join((CharSequence)",", expectedTypes));
    }

    private static String topmostInterfaceOf(Object actualInputType) {
        if (actualInputType == null) {
            return null;
        }
        if (List.class.isAssignableFrom(actualInputType.getClass())) {
            return List.class.getSimpleName();
        }
        if (Map.class.isAssignableFrom(actualInputType.getClass())) {
            return Map.class.getSimpleName();
        }
        return actualInputType.getClass().getSimpleName();
    }
}

