/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.commons;

import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import de.codecentric.reedelk.runtime.api.message.content.MimeType;
import de.codecentric.reedelk.runtime.api.message.content.TypedPublisher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class StreamUtils {
    private StreamUtils() {
    }

    public static class FromObject {
        private FromObject() {
        }

        public static <T> List<T> consume(Publisher<T> stream) {
            List result = (List)Flux.from(stream).collectList().block();
            return result == null ? new ArrayList() : result;
        }
    }

    public static class FromString {
        private FromString() {
        }

        public static String consume(Publisher<byte[]> byteArrayStream, Charset charset) {
            byte[] byteArray = FromByteArray.consume(byteArrayStream);
            return new String(byteArray, charset);
        }

        public static String consume(Publisher<String> stream) {
            List result = (List)Flux.from(stream).collectList().block();
            return result == null ? null : String.join((CharSequence)"", result);
        }
    }

    public static class FromByteArray {
        private FromByteArray() {
        }

        public static Publisher<String> asStringStream(Publisher<byte[]> byteArrayStream, Charset charset) {
            return Flux.from(byteArrayStream).map(bytes -> {
                Charset conversionCharset = Optional.ofNullable(charset).orElseGet(Charset::defaultCharset);
                return new String((byte[])bytes, conversionCharset);
            });
        }

        public static Publisher<String> asStringStream(Publisher<byte[]> byteArrayStream) {
            return FromByteArray.asStringStream(byteArrayStream, Charset.defaultCharset());
        }

        public static TypedPublisher<?> fromMimeType(Publisher<byte[]> byteArrayStream, MimeType mimeType) {
            if (String.class == mimeType.javaType()) {
                Charset charset = mimeType.getCharset().orElse(null);
                Publisher<String> streamAsString = FromByteArray.asStringStream(byteArrayStream, charset);
                return TypedPublisher.fromString(streamAsString);
            }
            return TypedPublisher.fromByteArray(byteArrayStream);
        }

        public static byte[] consume(Publisher<byte[]> stream) {
            byte[] byArray;
            List bytesBlocks = (List)Flux.from(stream).collectList().block();
            if (bytesBlocks == null || bytesBlocks.size() == 0) {
                return new byte[0];
            }
            if (bytesBlocks.size() == 1) {
                return (byte[])bytesBlocks.get(0);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                bytesBlocks.forEach(bytesBlock -> {
                    try {
                        out.write((byte[])bytesBlock);
                    }
                    catch (IOException exception) {
                        throw new PlatformException(exception);
                    }
                });
                byArray = out.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new PlatformException(exception);
                }
            }
            out.close();
            return byArray;
        }
    }
}

