/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.commons;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class StackTraceUtils {
    public static Publisher<byte[]> asByteStream(Throwable exception) {
        String exceptionAsString = StackTraceUtils.asString(exception);
        return exceptionAsString == null ? Mono.empty() : Mono.just((Object)exceptionAsString.getBytes());
    }

    public static byte[] asByteArray(Throwable exception) {
        String exceptionAsString = StackTraceUtils.asString(exception);
        return exceptionAsString == null ? new byte[]{} : exceptionAsString.getBytes();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String asString(Throwable exception) {
        try (StringWriter stringWriter = new StringWriter();){
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                exception.printStackTrace(printWriter);
                String string = stringWriter.toString();
                printWriter.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return String.format("Error: could not serialize exception as byte stream [%s]", e.getMessage());
        }
    }

    public static Throwable rootCauseOf(Throwable throwable) {
        Throwable rootCause;
        Objects.requireNonNull(throwable);
        for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }

    public static String rootCauseMessageOf(Throwable throwable) {
        return StackTraceUtils.rootCauseOf(throwable).getMessage();
    }
}

