/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.commons;

import de.codecentric.reedelk.runtime.api.commons.StringUtils;
import de.codecentric.reedelk.runtime.api.script.dynamicvalue.DynamicValue;
import java.util.Arrays;
import java.util.Collection;

public class ScriptUtils {
    public static final String EMPTY_SCRIPT = "#[]";
    public static final String EVALUATE_PAYLOAD = "#[message.payload()]";
    private static final Collection<String> EVALUATE_PAYLOAD_TOKENS = Arrays.asList("message.payload()", "message.content().data()");

    public static boolean isScript(Object value) {
        return value instanceof String && ScriptUtils.isScript((String)value);
    }

    public static boolean isScript(String value) {
        if (value != null) {
            String trimmedValue = value.trim();
            return trimmedValue.startsWith("#[") && trimmedValue.endsWith("]");
        }
        return false;
    }

    public static String unwrap(String value) {
        return ScriptUtils.isScript(value) ? value.substring(2, value.length() - 1) : value;
    }

    public static String asScript(String value) {
        return value == null ? EMPTY_SCRIPT : "#[" + value + "]";
    }

    public static boolean isEvaluateMessagePayload(DynamicValue<?> dynamicValue) {
        if (dynamicValue == null) {
            return false;
        }
        if (dynamicValue.isScript() && StringUtils.isNotBlank(dynamicValue.body())) {
            String unwrappedScript = ScriptUtils.unwrap(dynamicValue.body());
            return EVALUATE_PAYLOAD_TOKENS.contains(StringUtils.trim(unwrappedScript));
        }
        return false;
    }

    public static boolean isBlank(String script) {
        String unwrappedScript = ScriptUtils.unwrap(script);
        return StringUtils.isBlank(unwrappedScript);
    }

    public static boolean isNotBlank(String script) {
        String unwrappedScript = ScriptUtils.unwrap(script);
        return StringUtils.isNotBlank(unwrappedScript);
    }
}

