/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.reedelk.runtime.api.commons;

import de.codecentric.reedelk.runtime.api.commons.Preconditions;
import de.codecentric.reedelk.runtime.api.exception.PlatformException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Scanner;

public class FileUtils {
    private static final int NOT_FOUND = -1;

    private FileUtils() {
    }

    public static boolean hasExtension(Path path, String suffix) {
        String fileName = path.getFileName().toString();
        String extension = FileUtils.getExtension(fileName);
        return suffix.equals(extension);
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileUtils.indexOfExtension(filename);
        return index == -1 ? "" : filename.substring(index + 1);
    }

    public static String removeExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        FileUtils.failIfNullBytePresent(fileName);
        int index = FileUtils.indexOfExtension(fileName);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static boolean exists(String file) {
        Preconditions.checkNotNull(file, "file");
        return new File(file).exists();
    }

    private static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        return filename.lastIndexOf(File.separatorChar);
    }

    private static void failIfNullBytePresent(String path) {
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            if (path.charAt(i) != '\u0000') continue;
            throw new IllegalArgumentException("Null byte present in file/path name.");
        }
    }

    public static class ReadFromURL {
        public static String asString(URL url) {
            Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.toString());
            try {
                scanner.useDelimiter("\\A");
                String string = scanner.hasNext() ? scanner.next() : "";
                scanner.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new PlatformException(String.format("String from URL=[%s] could not be read.", url.getPath()), exception);
                }
            }
        }
    }
}

